/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.datapack;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlaneLiquidFuelReloadListener
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Map<FluidType, Integer> fuelMap = new HashMap<FluidType, Integer>();

    public PlaneLiquidFuelReloadListener() {
        super(GSON, "plane_liquid_fuels");
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        fuelMap.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            try {
                JsonObject jsonObject = GsonHelper.m_13918_((JsonElement)entry.getValue(), (String)"top element");
                FluidType fluidType = (FluidType)((IForgeRegistry)ForgeRegistries.FLUID_TYPES.get()).getValue(new ResourceLocation(jsonObject.get("fluid").getAsString()));
                if (fluidType == null) continue;
                int fuelPerMb = jsonObject.get("burn_time_per_mb").getAsInt();
                fuelMap.put(fluidType, fuelPerMb);
            }
            catch (Exception e) {
                LOGGER.error("Parsing error loading plane liquid fuel {}", (Object)entry.getKey(), (Object)e);
            }
        }
    }
}

