/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.entities;

import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import xyz.przemyk.simpleplanes.entities.LargePlaneEntity;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.misc.MathUtil;
import xyz.przemyk.simpleplanes.setup.SimplePlanesConfig;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;

public class HelicopterEntity
extends LargePlaneEntity {
    public static final EntityDataAccessor<Boolean> MOVE_UP = SynchedEntityData.m_135353_(HelicopterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public HelicopterEntity(EntityType<? extends HelicopterEntity> entityTypeIn, Level worldIn) {
        super((EntityType<? extends LargePlaneEntity>)entityTypeIn, worldIn);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MOVE_UP, (Object)false);
    }

    @Override
    protected PlaneEntity.TempMotionVars getMotionVars() {
        PlaneEntity.TempMotionVars motionTempMotionVars = super.getMotionVars();
        motionTempMotionVars.passiveEnginePush = 0.028f;
        motionTempMotionVars.push = 0.05f;
        motionTempMotionVars.dragQuad *= 10.0;
        motionTempMotionVars.dragMul *= 2.0;
        return motionTempMotionVars;
    }

    @Override
    protected Vector3f getTickPush(PlaneEntity.TempMotionVars tempMotionVars) {
        if (tempMotionVars.moveForward < 0.0f && this.isPowered() && !((Boolean)this.f_19804_.m_135370_(MOVE_UP)).booleanValue()) {
            tempMotionVars.push = (float)((double)tempMotionVars.push * 0.2);
        }
        if (tempMotionVars.moveForward > 0.0f && this.isPowered() && !((Boolean)this.f_19804_.m_135370_(MOVE_UP)).booleanValue()) {
            tempMotionVars.push = (float)((double)tempMotionVars.push * 1.5);
        }
        if (this.isPowered() && ((Boolean)this.f_19804_.m_135370_(MOVE_UP)).booleanValue() && tempMotionVars.moveForward >= 0.0f) {
            tempMotionVars.push = (float)((double)tempMotionVars.push + 0.01 * (double)this.getThrottle());
        }
        return this.transformPos(new Vector3f(0.0f, tempMotionVars.push, 0.0f));
    }

    @Override
    protected void tickPitch(PlaneEntity.TempMotionVars tempMotionVars) {
        if (this.getHealth() <= 0) {
            this.m_146926_(-2.0f);
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        } else if (!this.m_20096_()) {
            if (tempMotionVars.moveForward > 0.0f) {
                this.m_146926_(Math.max(this.m_146909_() - 1.0f, -20.0f));
            } else if (tempMotionVars.moveForward < 0.0f && ((Boolean)this.f_19804_.m_135370_(MOVE_UP)).booleanValue()) {
                this.m_146926_(Math.min(this.m_146909_() + 1.0f, 20.0f));
            } else {
                this.m_146926_(MathUtil.lerpAngle(0.2f, this.m_146909_(), 0.0f));
                double drag = 0.999;
                this.m_20256_(this.m_20184_().m_82542_(drag, 1.0, drag));
            }
        }
    }

    @Override
    protected void tickYaw() {
    }

    @Override
    protected boolean tickOnGround(PlaneEntity.TempMotionVars tempMotionVars) {
        float push = tempMotionVars.push;
        super.tickOnGround(tempMotionVars);
        tempMotionVars.push = (Boolean)this.f_19804_.m_135370_(MOVE_UP) != false ? push : 0.0f;
        return false;
    }

    @Override
    public int getFuelCost() {
        return (Integer)SimplePlanesConfig.HELICOPTER_FUEL_COST.get();
    }

    @Override
    protected Quaternionf tickRotateMotion(PlaneEntity.TempMotionVars tempMotionVars, Quaternionf q, Vec3 motion) {
        return q;
    }

    @Override
    protected void tickRoll(PlaneEntity.TempMotionVars tempMotionVars) {
        if (this.getHealth() <= 0) {
            this.m_146922_(this.m_146908_() + (this.m_19879_() % 2 == 0 ? 16.0f : -16.0f));
            return;
        }
        if (!((Boolean)this.f_19804_.m_135370_(MOVE_UP)).booleanValue()) {
            this.m_146922_(this.m_146908_() - tempMotionVars.moveStrafing * 2.0f);
            this.rotationRoll = tempMotionVars.moveForward > 0.0f && !this.m_20096_() ? MathUtil.lerpAngle(0.1f, this.rotationRoll, tempMotionVars.moveStrafing * 30.0f) : MathUtil.lerpAngle(0.1f, this.rotationRoll, 0.0f);
        } else if (!this.m_20096_()) {
            this.rotationRoll = MathUtil.lerpAngle(0.1f, this.rotationRoll, tempMotionVars.moveStrafing * 50.0f);
        }
    }

    @Override
    public void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        this.positionRiderGeneric(passenger);
        int index = this.m_20197_().indexOf(passenger);
        if (index == 0) {
            Vector3f pos = this.transformPos(new Vector3f(0.0f, (float)(this.m_6048_() + passenger.m_6049_()), 0.5f));
            moveFunction.m_20372_(passenger, this.m_20185_() + (double)pos.x(), this.m_20186_() + (double)pos.y(), this.m_20189_() + (double)pos.z());
        } else {
            if (this.hasLargeUpgrade) {
                ++index;
            }
            switch (index) {
                case 1: {
                    Vector3f pos = this.transformPos(new Vector3f(0.0f, (float)(this.m_6048_() + this.getEntityYOffset(passenger)), -0.5f));
                    moveFunction.m_20372_(passenger, this.m_20185_() + (double)pos.x(), this.m_20186_() + (double)pos.y(), this.m_20189_() + (double)pos.z());
                    break;
                }
                case 2: {
                    Vector3f pos = this.transformPos(new Vector3f(-1.0f, (float)(this.m_6048_() + passenger.m_6049_() - (double)0.4f), 0.0f));
                    moveFunction.m_20372_(passenger, this.m_20185_() + (double)pos.x(), this.m_20186_() + (double)pos.y(), this.m_20189_() + (double)pos.z());
                    break;
                }
                case 3: {
                    Vector3f pos = this.transformPos(new Vector3f(1.0f, (float)(this.m_6048_() + passenger.m_6049_()) - 0.4f, 0.0f));
                    moveFunction.m_20372_(passenger, this.m_20185_() + (double)pos.x(), this.m_20186_() + (double)pos.y(), this.m_20189_() + (double)pos.z());
                }
            }
        }
    }

    @Override
    public double getEntityYOffset(Entity passenger) {
        if (passenger instanceof Villager) {
            return ((Villager)passenger).m_6162_() ? -0.1 : -0.35;
        }
        return passenger.m_6049_();
    }

    @Override
    protected Item getItem() {
        return (Item)SimplePlanesItems.HELICOPTER_ITEM.get();
    }

    @Override
    public boolean canAddUpgrade(UpgradeType upgradeType) {
        if (upgradeType == SimplePlanesUpgrades.SOLAR_PANEL.get()) {
            return false;
        }
        return super.canAddUpgrade(upgradeType);
    }

    @Override
    public double getCameraDistanceMultiplayer() {
        return (Double)SimplePlanesConfig.HELI_CAMERA_DISTANCE_MULTIPLIER.get();
    }

    public void setMoveUp(boolean up) {
        this.f_19804_.m_135381_(MOVE_UP, (Object)up);
    }
}

