/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.misc;

import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

public class MathUtil {
    public static double getHorizontalDistanceSqr(Vec3 vec3) {
        return Math.sqrt(vec3.f_82479_ * vec3.f_82479_ + vec3.f_82481_ * vec3.f_82481_);
    }

    public static double normalizedDotProduct(Vec3 v1, Vec3 v2) {
        return v1.m_82526_(v2) / (v1.m_82553_() * v2.m_82553_());
    }

    public static float getPitch(Vec3 motion) {
        double y = motion.f_82480_;
        return (float)Math.toDegrees(Math.atan2(y, Math.sqrt(motion.f_82479_ * motion.f_82479_ + motion.f_82481_ * motion.f_82481_)));
    }

    public static float getYaw(Vec3 motion) {
        return (float)Math.toDegrees(Math.atan2(-motion.f_82479_, motion.f_82481_));
    }

    public static float lerpAngle(float perc, float start, float end) {
        return start + perc * Mth.m_14177_((float)(end - start));
    }

    public static float lerpAngle180(float perc, float start, float end) {
        if (MathUtil.degreesDifferenceAbs(start, end) > 90.0) {
            end += 180.0f;
        }
        return start + perc * Mth.m_14177_((float)(end - start));
    }

    public static double lerpAngle180(double perc, double start, double end) {
        if (MathUtil.degreesDifferenceAbs(start, end) > 90.0) {
            end += 180.0;
        }
        return start + perc * Mth.m_14175_((double)(end - start));
    }

    public static double lerpAngle(double perc, double start, double end) {
        return start + perc * Mth.m_14175_((double)(end - start));
    }

    public static double degreesDifferenceAbs(double p_203301_0_, double p_203301_1_) {
        return Math.abs(MathUtil.wrapSubtractDegrees(p_203301_0_, p_203301_1_));
    }

    public static double wrapSubtractDegrees(double p_203302_0_, double p_203302_1_) {
        return Mth.m_14175_((double)(p_203302_1_ - p_203302_0_));
    }

    public static Vec3 rotationToVector(double yaw, double pitch) {
        yaw = Math.toRadians(yaw);
        pitch = Math.toRadians(pitch);
        double xzLen = Math.cos(pitch);
        double x = -xzLen * Math.sin(yaw);
        double y = Math.sin(pitch);
        double z = xzLen * Math.cos(-yaw);
        return new Vec3(x, y, z);
    }

    public static Vec3 rotationToVector(double yaw, double pitch, double size) {
        Vec3 vec = MathUtil.rotationToVector(yaw, pitch);
        return vec.m_82490_(size / vec.m_82553_());
    }

    public static EulerAngles toEulerAngles(Quaternionf q) {
        EulerAngles angles = new EulerAngles();
        double sinr_cosp = 2.0f * (q.w() * q.z() + q.x() * q.y());
        double cosr_cosp = 1.0f - 2.0f * (q.z() * q.z() + q.x() * q.x());
        angles.roll = Math.toDegrees(Math.atan2(sinr_cosp, cosr_cosp));
        double sinp = 2.0f * (q.w() * q.x() - q.y() * q.z());
        angles.pitch = Math.abs(sinp) >= 0.999 ? -Math.toDegrees(Math.signum(sinp) * Math.PI / 2.0) : -Math.toDegrees(Math.asin(sinp));
        double siny_cosp = 2.0f * (q.w() * q.y() + q.z() * q.x());
        double cosy_cosp = 1.0f - 2.0f * (q.x() * q.x() + q.y() * q.y());
        angles.yaw = Math.toDegrees(Math.atan2(siny_cosp, cosy_cosp));
        return angles;
    }

    public static float fastInvSqrt(float number) {
        float f = 0.5f * number;
        int i = Float.floatToIntBits(number);
        i = 1597463007 - (i >> 1);
        number = Float.intBitsToFloat(i);
        return number * (1.5f - f * number * number);
    }

    public static Quaternionf normalizeQuaternionf(Quaternionf q) {
        float f = q.x() * q.x() + q.y() * q.y() + q.z() * q.z() + q.w() * q.w();
        float x = q.x();
        float y = q.y();
        float z = q.z();
        float w = q.w();
        if (f > 1.0E-6f) {
            float f1 = MathUtil.fastInvSqrt(f);
            return new Quaternionf(x *= f1, y *= f1, z *= f1, w *= f1);
        }
        return new Quaternionf(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public static Quaternionf toQuaternionf(double yaw, double pitch, double roll) {
        yaw = Math.toRadians(yaw);
        pitch = -Math.toRadians(pitch);
        roll = Math.toRadians(roll);
        double cy = Math.cos(yaw * 0.5);
        double sy = Math.sin(yaw * 0.5);
        double cp = Math.cos(pitch * 0.5);
        double sp = Math.sin(pitch * 0.5);
        double cr = Math.cos(roll * 0.5);
        double sr = Math.sin(roll * 0.5);
        float w = (float)(cr * cp * cy + sr * sp * sy);
        float z = (float)(sr * cp * cy - cr * sp * sy);
        float x = (float)(cr * sp * cy + sr * cp * sy);
        float y = (float)(cr * cp * sy - sr * sp * cy);
        return new Quaternionf(x, y, z, w);
    }

    public static Quaternionf lerpQ(float perc, Quaternionf start, Quaternionf end) {
        double DOT_THRESHOLD;
        start = MathUtil.normalizeQuaternionf(start);
        end = MathUtil.normalizeQuaternionf(end);
        double dot = start.x() * end.x() + start.y() * end.y() + start.z() * end.z() + start.w() * end.w();
        if (dot < 0.0) {
            end = new Quaternionf(-end.x(), -end.y(), -end.z(), -end.w());
            dot = -dot;
        }
        if (dot > (DOT_THRESHOLD = 0.9995)) {
            Quaternionf quaternionf = new Quaternionf(start.x() * (1.0f - perc) + end.x() * perc, start.y() * (1.0f - perc) + end.y() * perc, start.z() * (1.0f - perc) + end.z() * perc, start.w() * (1.0f - perc) + end.w() * perc);
            return MathUtil.normalizeQuaternionf(quaternionf);
        }
        double theta_0 = Math.acos(dot);
        double theta = theta_0 * (double)perc;
        double sin_theta = Math.sin(theta);
        double sin_theta_0 = Math.sin(theta_0);
        float s0 = (float)(Math.cos(theta) - dot * sin_theta / sin_theta_0);
        float s1 = (float)(sin_theta / sin_theta_0);
        Quaternionf quaternionf = new Quaternionf(start.x() * s0 + end.x() * s1, start.y() * s0 + end.y() * s1, start.z() * s0 + end.z() * s1, start.w() * s0 + end.w() * s1);
        return MathUtil.normalizeQuaternionf(quaternionf);
    }

    public static class EulerAngles {
        public double pitch;
        public double yaw;
        public double roll;

        public EulerAngles() {
        }

        public EulerAngles(EulerAngles a) {
            this.pitch = a.pitch;
            this.yaw = a.yaw;
            this.roll = a.roll;
        }

        public EulerAngles copy() {
            return new EulerAngles(this);
        }

        public String toString() {
            return "EulerAngles{pitch=" + this.pitch + ", yaw=" + this.yaw + ", roll=" + this.roll + "}";
        }
    }
}

