/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.setup;

import com.google.common.collect.ImmutableSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import xyz.przemyk.simpleplanes.entities.CargoPlaneEntity;
import xyz.przemyk.simpleplanes.entities.HelicopterEntity;
import xyz.przemyk.simpleplanes.entities.LargePlaneEntity;
import xyz.przemyk.simpleplanes.entities.ParachuteEntity;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;

public class SimplePlanesEntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"simpleplanes");
    public static final RegistryObject<EntityType<PlaneEntity>> PLANE = ENTITIES.register("plane", () -> SimplePlanesEntities.createEntityType(PlaneEntity::new, EntityDimensions.m_20395_((float)2.5f, (float)1.8f)));
    public static final RegistryObject<EntityType<LargePlaneEntity>> LARGE_PLANE = ENTITIES.register("large_plane", () -> SimplePlanesEntities.createEntityType(LargePlaneEntity::new, EntityDimensions.m_20395_((float)3.0f, (float)2.3f)));
    public static final RegistryObject<EntityType<CargoPlaneEntity>> CARGO_PLANE = ENTITIES.register("cargo_plane", () -> SimplePlanesEntities.createEntityType(CargoPlaneEntity::new, EntityDimensions.m_20395_((float)3.0f, (float)2.3f)));
    public static final RegistryObject<EntityType<HelicopterEntity>> HELICOPTER = ENTITIES.register("helicopter", () -> SimplePlanesEntities.createEntityType(HelicopterEntity::new, EntityDimensions.m_20395_((float)2.5f, (float)2.2f)));
    public static final RegistryObject<EntityType<ParachuteEntity>> PARACHUTE = ENTITIES.register("parachute", () -> SimplePlanesEntities.createEntityType(ParachuteEntity::new, EntityDimensions.m_20395_((float)1.0f, (float)1.0f)));

    public static void init() {
        ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    private static <T extends Entity> EntityType<T> createEntityType(EntityType.EntityFactory<T> factory, EntityDimensions size) {
        return new EntityType(factory, MobCategory.MISC, true, true, false, true, ImmutableSet.of(), size, 5, 3, FeatureFlags.f_244377_);
    }
}

