/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.setup;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import xyz.przemyk.simpleplanes.container.PlaneWorkbenchContainer;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.items.DescriptionItem;
import xyz.przemyk.simpleplanes.items.ParachuteItem;
import xyz.przemyk.simpleplanes.items.PlaneArmorItem;
import xyz.przemyk.simpleplanes.items.PlaneItem;
import xyz.przemyk.simpleplanes.setup.SimplePlanesBlocks;
import xyz.przemyk.simpleplanes.setup.SimplePlanesEntities;

@Mod.EventBusSubscriber(modid="simpleplanes", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SimplePlanesItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"simpleplanes");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"simpleplanes");
    public static final RegistryObject<Item> PROPELLER = ITEMS.register("propeller", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> FLOATY_BEDDING = ITEMS.register("floaty_bedding", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> BOOSTER = ITEMS.register("booster", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> HEALING = ITEMS.register("healing", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> ARMOR = ITEMS.register("armor", () -> new PlaneArmorItem(new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> SOLAR_PANEL = ITEMS.register("solar_panel", () -> new Item(new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> FOLDING = ITEMS.register("folding", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> SUPPLY_CRATE = ITEMS.register("supply_crate", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> SEATS = ITEMS.register("seats", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> SHOOTER = ITEMS.register("shooter", () -> new DescriptionItem(new Item.Properties(), (Component)Component.m_237110_((String)"simpleplanes.shooter_desc", (Object[])new Object[]{Component.m_237117_((String)"key.plane_inventory_open.desc"), Component.m_237117_((String)"key.attack")})));
    public static final RegistryObject<Item> ELECTRIC_ENGINE = ITEMS.register("electric_engine", () -> new DescriptionItem(new Item.Properties(), (Component)Component.m_237110_((String)"simpleplanes.press_key", (Object[])new Object[]{Component.m_237117_((String)"key.plane_inventory_open.desc")})));
    public static final RegistryObject<Item> FURNACE_ENGINE = ITEMS.register("furnace_engine", () -> new DescriptionItem(new Item.Properties(), (Component)Component.m_237110_((String)"simpleplanes.press_key", (Object[])new Object[]{Component.m_237117_((String)"key.plane_inventory_open.desc")})));
    public static final RegistryObject<Item> LIQUID_ENGINE = ITEMS.register("liquid_engine", () -> new DescriptionItem(new Item.Properties(), (Component)Component.m_237110_((String)"simpleplanes.press_key", (Object[])new Object[]{Component.m_237117_((String)"key.plane_inventory_open.desc")})));
    public static final RegistryObject<Item> WRENCH = ITEMS.register("wrench", () -> new Item(new Item.Properties()));
    public static final RegistryObject<BlockItem> PLANE_WORKBENCH = ITEMS.register("plane_workbench", () -> new BlockItem((Block)SimplePlanesBlocks.PLANE_WORKBENCH_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<BlockItem> CHARGING_STATION = ITEMS.register("charging_station", () -> new BlockItem((Block)SimplePlanesBlocks.CHARGING_STATION_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<PlaneItem> PLANE_ITEM = ITEMS.register("plane", () -> new PlaneItem(new Item.Properties(), (Supplier<? extends EntityType<? extends PlaneEntity>>)SimplePlanesEntities.PLANE));
    public static final RegistryObject<PlaneItem> LARGE_PLANE_ITEM = ITEMS.register("large_plane", () -> new PlaneItem(new Item.Properties(), (Supplier<? extends EntityType<? extends PlaneEntity>>)SimplePlanesEntities.LARGE_PLANE));
    public static final RegistryObject<PlaneItem> CARGO_PLANE_ITEM = ITEMS.register("cargo_plane", () -> new PlaneItem(new Item.Properties(), (Supplier<? extends EntityType<? extends PlaneEntity>>)SimplePlanesEntities.CARGO_PLANE));
    public static final RegistryObject<PlaneItem> HELICOPTER_ITEM = ITEMS.register("helicopter", () -> new PlaneItem(new Item.Properties(), (Supplier<? extends EntityType<? extends PlaneEntity>>)SimplePlanesEntities.HELICOPTER));
    public static final RegistryObject<ParachuteItem> PARACHUTE_ITEM = ITEMS.register("parachute", () -> new ParachuteItem(new Item.Properties()));
    public static final RegistryObject<CreativeModeTab> PLANES_TAB = CREATIVE_MODE_TABS.register("planes_tab", () -> CreativeModeTab.builder().m_257737_(() -> ((PlaneItem)((Object)((Object)((Object)PLANE_ITEM.get())))).m_7968_()).m_257941_((Component)Component.m_237115_((String)"simpleplanes.planes_tab")).m_257501_((parameters, output) -> {
        output.m_246326_((ItemLike)PROPELLER.get());
        output.m_246326_((ItemLike)FLOATY_BEDDING.get());
        output.m_246326_((ItemLike)BOOSTER.get());
        output.m_246326_((ItemLike)HEALING.get());
        output.m_246326_((ItemLike)ARMOR.get());
        output.m_246326_((ItemLike)SOLAR_PANEL.get());
        output.m_246326_((ItemLike)FOLDING.get());
        output.m_246326_((ItemLike)SUPPLY_CRATE.get());
        output.m_246326_((ItemLike)SEATS.get());
        output.m_246326_((ItemLike)SHOOTER.get());
        output.m_246326_((ItemLike)ELECTRIC_ENGINE.get());
        output.m_246326_((ItemLike)FURNACE_ENGINE.get());
        output.m_246326_((ItemLike)LIQUID_ENGINE.get());
        output.m_246326_((ItemLike)WRENCH.get());
        output.m_246326_((ItemLike)PLANE_WORKBENCH.get());
        output.m_246326_((ItemLike)CHARGING_STATION.get());
        output.m_246326_((ItemLike)PARACHUTE_ITEM.get());
        ForgeRegistries.BLOCKS.tags().getTag(PlaneWorkbenchContainer.PLANE_MATERIALS_TAG).forEach(block -> {
            ItemStack planeStack = new ItemStack((ItemLike)PLANE_ITEM.get());
            ItemStack largePlaneStack = new ItemStack((ItemLike)LARGE_PLANE_ITEM.get());
            ItemStack cargoPlaneStack = new ItemStack((ItemLike)CARGO_PLANE_ITEM.get());
            ItemStack heliStack = new ItemStack((ItemLike)HELICOPTER_ITEM.get());
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128359_("material", ForgeRegistries.BLOCKS.getKey(block).toString());
            planeStack.m_41700_("EntityTag", (Tag)itemTag);
            largePlaneStack.m_41700_("EntityTag", (Tag)itemTag);
            cargoPlaneStack.m_41700_("EntityTag", (Tag)itemTag);
            heliStack.m_41700_("EntityTag", (Tag)itemTag);
            output.m_246342_(planeStack);
            output.m_246342_(largePlaneStack);
            output.m_246342_(cargoPlaneStack);
            output.m_246342_(heliStack);
        });
    }).m_257652_());

    public static void init() {
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        CREATIVE_MODE_TABS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    public static List<PlaneItem> getPlaneItems() {
        ArrayList<PlaneItem> planeItems = new ArrayList<PlaneItem>(3);
        planeItems.add((PlaneItem)((Object)PLANE_ITEM.get()));
        planeItems.add((PlaneItem)((Object)LARGE_PLANE_ITEM.get()));
        planeItems.add((PlaneItem)((Object)CARGO_PLANE_ITEM.get()));
        planeItems.add((PlaneItem)((Object)HELICOPTER_ITEM.get()));
        return planeItems;
    }
}

