/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.item.gun;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.ReloadState;
import com.tacz.guns.api.item.GunTabType;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.IAmmoBox;
import com.tacz.guns.api.item.IAnimationItem;
import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.builder.AmmoItemBuilder;
import com.tacz.guns.api.item.builder.GunItemBuilder;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.client.renderer.item.GunItemRendererWrapper;
import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.entity.shooter.ShooterDataHolder;
import com.tacz.guns.inventory.tooltip.GunTooltip;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.pojo.data.gun.FeedType;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.util.AllowAttachmentTagMatcher;
import com.tacz.guns.util.AttachmentDataUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class AbstractGunItem
extends Item
implements IGun,
IAnimationItem {
    protected AbstractGunItem(Item.Properties pProperties) {
        super(pProperties);
    }

    private static Comparator<Map.Entry<ResourceLocation, CommonGunIndex>> idNameSort() {
        return Comparator.comparingInt(m -> ((CommonGunIndex)m.getValue()).getSort());
    }

    public abstract boolean startBolt(ShooterDataHolder var1, ItemStack var2, LivingEntity var3);

    public abstract boolean tickBolt(ShooterDataHolder var1, ItemStack var2, LivingEntity var3);

    public abstract void shoot(ShooterDataHolder var1, ItemStack var2, Supplier<Float> var3, Supplier<Float> var4, LivingEntity var5);

    public abstract boolean startReload(ShooterDataHolder var1, ItemStack var2, LivingEntity var3);

    public abstract ReloadState tickReload(ShooterDataHolder var1, ItemStack var2, LivingEntity var3);

    public abstract void interruptReload(ShooterDataHolder var1, ItemStack var2, LivingEntity var3);

    public abstract void fireSelect(ShooterDataHolder var1, ItemStack var2);

    public abstract void melee(ShooterDataHolder var1, LivingEntity var2, ItemStack var3);

    public void tickHeat(ShooterDataHolder dataHolder, ItemStack gunItem, LivingEntity shooter) {
    }

    public void doBulletSpread(ShooterDataHolder dataHolder, ItemStack gunItem, LivingEntity shooter, Projectile projectile, int bulletCnt, float processedSpeed, float inaccuracy, float pitch, float yaw) {
        projectile.m_37251_((Entity)projectile, pitch, yaw, 0.0f, processedSpeed, inaccuracy);
    }

    public boolean canReload(LivingEntity shooter, ItemStack gunItem) {
        int maxAmmoCount;
        ResourceLocation gunId = this.getGunId(gunItem);
        CommonGunIndex gunIndex = TimelessAPI.getCommonGunIndex(gunId).orElse(null);
        if (gunIndex == null) {
            return false;
        }
        int currentAmmoCount = this.getCurrentAmmoCount(gunItem);
        if (currentAmmoCount >= (maxAmmoCount = AttachmentDataUtils.getAmmoCountWithAttachment(gunItem, gunIndex.getGunData()))) {
            return false;
        }
        if (this.useInventoryAmmo(gunItem)) {
            return false;
        }
        if (gunIndex.getGunData().getReloadData().isInfinite()) {
            return true;
        }
        if (this.useDummyAmmo(gunItem)) {
            return this.getDummyAmmoAmount(gunItem) > 0;
        }
        return shooter.getCapability(ForgeCapabilities.ITEM_HANDLER, null).map(cap -> {
            for (int i = 0; i < cap.getSlots(); ++i) {
                IAmmoBox iAmmoBox;
                IAmmo iAmmo;
                ItemStack checkAmmoStack = cap.getStackInSlot(i);
                Item patt5747$temp = checkAmmoStack.m_41720_();
                if (patt5747$temp instanceof IAmmo && (iAmmo = (IAmmo)patt5747$temp).isAmmoOfGun(gunItem, checkAmmoStack)) {
                    return true;
                }
                Item patt5918$temp = checkAmmoStack.m_41720_();
                if (!(patt5918$temp instanceof IAmmoBox) || !(iAmmoBox = (IAmmoBox)patt5918$temp).isAmmoBoxOfGun(gunItem, checkAmmoStack)) continue;
                return true;
            }
            return false;
        }).orElse(false);
    }

    @Override
    public void dropAllAmmo(Player player, ItemStack gunItem) {
        if (this.useInventoryAmmo(gunItem)) {
            return;
        }
        int ammoCount = this.getCurrentAmmoCount(gunItem);
        if (ammoCount <= 0) {
            return;
        }
        ResourceLocation gunId = this.getGunId(gunItem);
        TimelessAPI.getCommonGunIndex(gunId).ifPresent(index -> {
            if (this.useDummyAmmo(gunItem)) {
                this.setCurrentAmmoCount(gunItem, 0);
                if (index.getGunData().getReloadData().getType().equals((Object)FeedType.FUEL)) {
                    return;
                }
                this.addDummyAmmoAmount(gunItem, ammoCount);
                return;
            }
            ResourceLocation ammoId = index.getGunData().getAmmoId();
            if (player.m_7500_()) {
                int maxAmmCount = AttachmentDataUtils.getAmmoCountWithAttachment(gunItem, index.getGunData());
                this.setCurrentAmmoCount(gunItem, maxAmmCount);
                return;
            }
            if (index.getGunData().getReloadData().getType().equals((Object)FeedType.FUEL)) {
                this.setCurrentAmmoCount(gunItem, 0);
                return;
            }
            TimelessAPI.getCommonAmmoIndex(ammoId).ifPresent(ammoIndex -> {
                int stackSize = ammoIndex.getStackSize();
                int tmpAmmoCount = ammoCount;
                int roundCount = tmpAmmoCount / (stackSize + 1);
                for (int i = 0; i <= roundCount; ++i) {
                    int count = Math.min(tmpAmmoCount, stackSize);
                    ItemStack ammoItem = AmmoItemBuilder.create().setId(ammoId).setCount(count).build();
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)ammoItem);
                    tmpAmmoCount -= stackSize;
                }
                this.setCurrentAmmoCount(gunItem, 0);
            });
        });
    }

    @Deprecated
    public int findAndExtractInventoryAmmos(IItemHandler itemHandler, ItemStack gunItem, int needAmmoCount) {
        return this.findAndExtractInventoryAmmo(itemHandler, gunItem, needAmmoCount);
    }

    public int findAndExtractInventoryAmmo(IItemHandler itemHandler, ItemStack gunItem, int needAmmoCount) {
        Item extractItem;
        IAmmo iAmmo;
        ItemStack checkAmmoStack;
        Item item;
        int cnt = needAmmoCount;
        for (int i = 0; !(i >= itemHandler.getSlots() || (item = (checkAmmoStack = itemHandler.getStackInSlot(i)).m_41720_()) instanceof IAmmo && (iAmmo = (IAmmo)item).isAmmoOfGun(gunItem, checkAmmoStack) && (cnt -= (extractItem = itemHandler.extractItem(i, cnt, false)).m_41613_()) <= 0); ++i) {
            IAmmoBox iAmmoBox;
            extractItem = checkAmmoStack.m_41720_();
            if (!(extractItem instanceof IAmmoBox) || !(iAmmoBox = (IAmmoBox)extractItem).isAmmoBoxOfGun(gunItem, checkAmmoStack)) continue;
            int boxAmmoCount = iAmmoBox.getAmmoCount(checkAmmoStack);
            int extractCount = Math.min(boxAmmoCount, cnt);
            int remainCount = boxAmmoCount - extractCount;
            iAmmoBox.setAmmoCount(checkAmmoStack, remainCount);
            if (remainCount <= 0) {
                iAmmoBox.setAmmoId(checkAmmoStack, DefaultAssets.EMPTY_AMMO_ID);
            }
            if ((cnt -= extractCount) <= 0) break;
        }
        return needAmmoCount - cnt;
    }

    public int findAndExtractDummyAmmo(ItemStack gunItem, int needAmmoCount) {
        int dummyAmmoCount = this.getDummyAmmoAmount(gunItem);
        int extractCount = Math.min(dummyAmmoCount, needAmmoCount);
        this.addDummyAmmoAmount(gunItem, -extractCount);
        return extractCount;
    }

    @Override
    public boolean allowAttachment(ItemStack gun, ItemStack attachmentItem) {
        IAttachment iAttachment = IAttachment.getIAttachmentOrNull(attachmentItem);
        IGun iGun = IGun.getIGunOrNull(gun);
        if (iGun != null && iAttachment != null) {
            ResourceLocation gunId = iGun.getGunId(gun);
            ResourceLocation attachmentId = iAttachment.getAttachmentId(attachmentItem);
            return AllowAttachmentTagMatcher.match(gunId, attachmentId);
        }
        return false;
    }

    @Override
    public boolean allowAttachmentType(ItemStack gun, AttachmentType type) {
        IGun iGun = IGun.getIGunOrNull(gun);
        if (iGun != null) {
            return TimelessAPI.getCommonGunIndex(iGun.getGunId(gun)).map(gunIndex -> {
                List<AttachmentType> allowAttachments = gunIndex.getGunData().getAllowAttachments();
                if (allowAttachments == null) {
                    return false;
                }
                return allowAttachments.contains((Object)type);
            }).orElse(false);
        }
        return false;
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public Component m_7626_(@Nonnull ItemStack stack) {
        ResourceLocation gunId = this.getGunId(stack);
        Optional<ClientGunIndex> gunIndex = TimelessAPI.getClientGunIndex(gunId);
        if (gunIndex.isPresent()) {
            return Component.m_237115_((String)gunIndex.get().getName());
        }
        return super.m_7626_(stack);
    }

    public static NonNullList<ItemStack> fillItemCategory(GunTabType type) {
        NonNullList stacks = NonNullList.m_122779_();
        TimelessAPI.getAllCommonGunIndex().stream().sorted(AbstractGunItem.idNameSort()).forEach(entry -> {
            String indexType;
            CommonGunIndex index = (CommonGunIndex)entry.getValue();
            GunData gunData = index.getGunData();
            String key = type.name().toLowerCase(Locale.US);
            if (key.equals(indexType = index.getType())) {
                ItemStack itemStack = GunItemBuilder.create().setId((ResourceLocation)entry.getKey()).setFireMode(gunData.getFireModeSet().get(0)).setAmmoCount(gunData.getAmmoAmount()).setHeatData(gunData.hasHeatData()).setAmmoInBarrel(true).build();
                stacks.add((Object)itemStack);
            }
        });
        return stacks;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new GunItemRendererWrapper();
            }
        });
    }

    @Nonnull
    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof IGun) {
            IGun iGun = (IGun)item;
            Optional<CommonGunIndex> optional = TimelessAPI.getCommonGunIndex(this.getGunId(stack));
            if (optional.isPresent()) {
                CommonGunIndex gunIndex = optional.get();
                ResourceLocation ammoId = gunIndex.getGunData().getAmmoId();
                return Optional.of(new GunTooltip(stack, iGun, ammoId, gunIndex));
            }
        }
        return Optional.empty();
    }

    @Override
    public boolean useInventoryAmmo(ItemStack gun) {
        if (gun.m_41720_() instanceof IGun) {
            Optional<CommonGunIndex> gunIndexOptional = TimelessAPI.getCommonGunIndex(this.getGunId(gun));
            if (gunIndexOptional.isEmpty()) {
                return false;
            }
            CommonGunIndex gunIndex = gunIndexOptional.get();
            return gunIndex.getGunData().getReloadData().getType().equals((Object)FeedType.INVENTORY);
        }
        return false;
    }

    @Override
    public boolean hasInventoryAmmo(LivingEntity shooter, ItemStack gun, boolean needCheckAmmo) {
        if (!this.useInventoryAmmo(gun)) {
            return false;
        }
        if (!needCheckAmmo) {
            return true;
        }
        if (this.useDummyAmmo(gun)) {
            return this.getDummyAmmoAmount(gun) > 0;
        }
        return shooter.getCapability(ForgeCapabilities.ITEM_HANDLER, null).map(cap -> {
            for (int i = 0; i < cap.getSlots(); ++i) {
                IAmmoBox iAmmoBox;
                IAmmo iAmmo;
                ItemStack checkAmmoStack = cap.getStackInSlot(i);
                Item patt16162$temp = checkAmmoStack.m_41720_();
                if (patt16162$temp instanceof IAmmo && (iAmmo = (IAmmo)patt16162$temp).isAmmoOfGun(gun, checkAmmoStack)) {
                    return true;
                }
                Item patt16329$temp = checkAmmoStack.m_41720_();
                if (!(patt16329$temp instanceof IAmmoBox) || !(iAmmoBox = (IAmmoBox)patt16329$temp).isAmmoBoxOfGun(gun, checkAmmoStack)) continue;
                return true;
            }
            return false;
        }).orElse(false);
    }

    @Override
    public int getRPM(ItemStack gun) {
        Item item = gun.m_41720_();
        if (item instanceof IGun) {
            IGun iGun = (IGun)item;
            return TimelessAPI.getCommonGunIndex(this.getGunId(gun)).map(CommonGunIndex::getGunData).map(gunData -> {
                FireMode fireMode = this.getFireMode(gun);
                int rpm = gunData.getRoundsPerMinute(fireMode);
                if (iGun.hasHeatData(gun)) {
                    rpm *= (int)iGun.lerpRPM(gun);
                }
                return rpm;
            }).orElse(300);
        }
        return 300;
    }

    @Override
    public boolean isCanCrawl(ItemStack gun) {
        if (gun.m_41720_() instanceof IGun) {
            return TimelessAPI.getCommonGunIndex(this.getGunId(gun)).map(CommonGunIndex::getGunData).map(GunData::isCanCrawl).orElse(false);
        }
        return false;
    }

    @Override
    public boolean isSame(ItemStack i, ItemStack j) {
        IGun iGun1 = IGun.getIGunOrNull(i);
        IGun iGun2 = IGun.getIGunOrNull(j);
        if (iGun1 != null && iGun2 != null) {
            return iGun1.getGunId(i).equals((Object)iGun2.getGunId(j));
        }
        if (i.m_41619_() || j.m_41619_()) {
            return i.m_41619_() && j.m_41619_();
        }
        return ItemStack.m_41728_((ItemStack)i, (ItemStack)j);
    }
}

