/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.block;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.item.builder.BlockItemBuilder;
import com.tacz.guns.api.item.nbt.BlockItemDataAccessor;
import com.tacz.guns.block.entity.GunSmithTableBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGunSmithTableBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public AbstractGunSmithTableBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public InteractionResult m_6227_(BlockState pState, Level level, BlockPos pos, Player player, InteractionHand pHand, BlockHitResult pHit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(this.getRootPos(pos, pState));
        if (blockEntity instanceof GunSmithTableBlockEntity) {
            GunSmithTableBlockEntity gunSmithTable = (GunSmithTableBlockEntity)blockEntity;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)gunSmithTable, buf -> {
                    ResourceLocation rl = gunSmithTable.getId() == null ? DefaultAssets.DEFAULT_BLOCK_ID : gunSmithTable.getId();
                    buf.m_130085_(rl);
                });
            }
        }
        return InteractionResult.CONSUME;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState blockState) {
        return new GunSmithTableBlockEntity(pos, blockState);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        Item item;
        super.m_6402_(world, pos, state, placer, stack);
        if (!world.f_46443_ && (item = stack.m_41720_()) instanceof BlockItemDataAccessor) {
            BlockItemDataAccessor accessor = (BlockItemDataAccessor)item;
            ResourceLocation id = accessor.getBlockId(stack);
            BlockEntity blockentity = world.m_7702_(pos);
            if (blockentity instanceof GunSmithTableBlockEntity) {
                GunSmithTableBlockEntity e = (GunSmithTableBlockEntity)blockentity;
                e.setId(id);
            }
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        BlockPos blockPos = this.getRootPos(pos, state);
        BlockEntity blockentity = level.m_7702_(blockPos);
        if (blockentity instanceof GunSmithTableBlockEntity) {
            GunSmithTableBlockEntity e = (GunSmithTableBlockEntity)blockentity;
            if (e.getId() != null) {
                return BlockItemBuilder.create((ItemLike)this).setId(e.getId()).build();
            }
            return new ItemStack((ItemLike)this);
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    public abstract boolean isRoot(BlockState var1);

    public float parseRotation(Direction direction) {
        return 90.0f * (float)(3 - direction.m_122416_()) - 90.0f;
    }

    public abstract BlockPos getRootPos(BlockPos var1, BlockState var2);
}

