/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.compat.kubejs;

import com.tacz.guns.api.GunProperties;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.api.item.gun.GunItemManager;
import com.tacz.guns.compat.kubejs.custom.CustomGunItemBuilder;
import com.tacz.guns.compat.kubejs.events.GunKubeJSEvents;
import com.tacz.guns.compat.kubejs.events.TimelessClientEvents;
import com.tacz.guns.compat.kubejs.events.TimelessCommonEvents;
import com.tacz.guns.compat.kubejs.events.TimelessServerEvents;
import com.tacz.guns.compat.kubejs.recipe.TimelessGunSmithTableRecipeSchema;
import com.tacz.guns.compat.kubejs.util.TimelessItemWrapper;
import dev.latvian.mods.kubejs.KubeJSPlugin;
import dev.latvian.mods.kubejs.recipe.schema.RegisterRecipeSchemasEvent;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.script.BindingsEvent;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;

public class TimelessKubeJSPlugin
extends KubeJSPlugin {
    public static final String KUBEJS_MODID = "kubejs";
    private static final Map<String, RegistryObject<? extends AbstractGunItem>> GUNTYPE_REGISTER_MAP = new HashMap<String, RegistryObject<? extends AbstractGunItem>>();

    public void init() {
        RegistryInfo.ITEM.addType("tacz_gun", CustomGunItemBuilder.class, CustomGunItemBuilder::new);
    }

    public void registerEvents() {
        TimelessCommonEvents.INSTANCE.init();
        TimelessServerEvents.INSTANCE.init();
        TimelessClientEvents.INSTANCE.init();
        GunKubeJSEvents.GROUP.register();
    }

    public void registerBindings(BindingsEvent event) {
        event.add("TimelessItem", TimelessItemWrapper.class);
        event.add("GunProperties", GunProperties.class);
    }

    public void registerRecipeSchemas(RegisterRecipeSchemasEvent event) {
        event.namespace("tacz").register("gun_smith_table_crafting", TimelessGunSmithTableRecipeSchema.SCHEMA);
    }

    public static void registerGunType(String typeName, RegistryObject<? extends AbstractGunItem> registryObject) {
        GUNTYPE_REGISTER_MAP.put(typeName, registryObject);
    }

    @SubscribeEvent
    public void onItemRegister(RegisterEvent event) {
        if (ModList.get().isLoaded(KUBEJS_MODID) && event.getRegistryKey().equals((Object)ForgeRegistries.ITEMS.getRegistryKey())) {
            for (Map.Entry<String, RegistryObject<? extends AbstractGunItem>> entry : GUNTYPE_REGISTER_MAP.entrySet()) {
                GunItemManager.registerGunItem(entry.getKey(), entry.getValue());
            }
        }
    }
}

