/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.compat.playeranimator.animation;

import com.google.common.collect.Maps;
import com.google.gson.JsonParseException;
import com.tacz.guns.GunMod;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.data.gson.AnimationSerializing;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class PlayerAnimatorAssetManager
extends SimplePreparableReloadListener<Map<ResourceLocation, HashMap<String, KeyframeAnimation>>> {
    private static PlayerAnimatorAssetManager INSTANCE;
    private final FileToIdConverter filetoidconverter = new FileToIdConverter("player_animator", ".json");
    private final HashMap<ResourceLocation, HashMap<String, KeyframeAnimation>> animations = new HashMap();

    public static PlayerAnimatorAssetManager get() {
        if (INSTANCE == null) {
            INSTANCE = new PlayerAnimatorAssetManager();
        }
        return INSTANCE;
    }

    void putAnimation(ResourceLocation id, InputStream stream) throws IOException {
        List keyframeAnimations = AnimationSerializing.deserializeAnimation((InputStream)stream);
        for (KeyframeAnimation animation : keyframeAnimations) {
            Object v = animation.extraData.get("name");
            if (!(v instanceof String)) continue;
            String text = (String)v;
            String name = PlayerAnimationRegistry.serializeTextToString((String)text).toLowerCase(Locale.ENGLISH);
            this.animations.computeIfAbsent(id, k -> Maps.newHashMap()).put(name, animation);
        }
    }

    Optional<KeyframeAnimation> getAnimations(ResourceLocation id, String name) {
        HashMap<String, KeyframeAnimation> animationHashMap = this.animations.get(id);
        if (animationHashMap == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(animationHashMap.get(name));
    }

    public boolean containsKey(ResourceLocation id) {
        return this.animations.containsKey(id);
    }

    public void clearAll() {
        this.animations.clear();
    }

    protected Map<ResourceLocation, HashMap<String, KeyframeAnimation>> prepare(ResourceManager manager, ProfilerFiller profiler) {
        HashMap output = Maps.newHashMap();
        for (Map.Entry entry : this.filetoidconverter.m_247457_(manager).entrySet()) {
            ResourceLocation resourcelocation = (ResourceLocation)entry.getKey();
            ResourceLocation resourcelocation1 = this.filetoidconverter.m_245273_(resourcelocation);
            try {
                BufferedReader reader = ((Resource)entry.getValue()).m_215508_();
                try {
                    List keyframeAnimations = AnimationSerializing.deserializeAnimation((Reader)reader);
                    for (KeyframeAnimation animation : keyframeAnimations) {
                        Object v = animation.extraData.get("name");
                        if (!(v instanceof String)) continue;
                        String text = (String)v;
                        String name = PlayerAnimationRegistry.serializeTextToString((String)text).toLowerCase(Locale.ENGLISH);
                        output.computeIfAbsent(resourcelocation1, k -> Maps.newHashMap()).put(name, animation);
                    }
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException jsonparseexception) {
                GunMod.LOGGER.warn("Failed to player animation file: {}, entry: {}", (Object)resourcelocation, entry);
            }
        }
        return output;
    }

    protected void apply(Map<ResourceLocation, HashMap<String, KeyframeAnimation>> map, ResourceManager manager, ProfilerFiller profiler) {
        this.animations.clear();
        this.animations.putAll(map);
    }
}

