/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.entity;

import com.google.common.collect.Lists;
import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.entity.ITargetEntity;
import com.tacz.guns.api.entity.KnockBackModifier;
import com.tacz.guns.api.event.common.EntityHurtByGunEvent;
import com.tacz.guns.api.event.common.EntityKillByGunEvent;
import com.tacz.guns.api.event.common.GunDamageSourcePart;
import com.tacz.guns.api.event.server.AmmoHitBlockEvent;
import com.tacz.guns.client.particle.AmmoParticleSpawner;
import com.tacz.guns.config.common.AmmoConfig;
import com.tacz.guns.config.sync.SyncConfig;
import com.tacz.guns.init.ModDamageTypes;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.event.ServerMessageGunHurt;
import com.tacz.guns.network.message.event.ServerMessageGunKill;
import com.tacz.guns.particles.BulletHoleOption;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.modifier.custom.AmmoSpeedModifier;
import com.tacz.guns.resource.modifier.custom.ArmorIgnoreModifier;
import com.tacz.guns.resource.modifier.custom.DamageModifier;
import com.tacz.guns.resource.modifier.custom.EffectiveRangeModifier;
import com.tacz.guns.resource.modifier.custom.ExplosionModifier;
import com.tacz.guns.resource.modifier.custom.HeadShotModifier;
import com.tacz.guns.resource.modifier.custom.IgniteModifier;
import com.tacz.guns.resource.modifier.custom.KnockbackModifier;
import com.tacz.guns.resource.modifier.custom.PierceModifier;
import com.tacz.guns.resource.pojo.data.gun.BulletData;
import com.tacz.guns.resource.pojo.data.gun.ExplosionData;
import com.tacz.guns.resource.pojo.data.gun.ExtraDamage;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource.pojo.data.gun.Ignite;
import com.tacz.guns.util.EntityUtil;
import com.tacz.guns.util.ExplodeUtil;
import com.tacz.guns.util.TacHitResult;
import com.tacz.guns.util.block.BlockRayTrace;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class EntityKineticBullet
extends Projectile
implements IEntityAdditionalSpawnData {
    public static final EntityType<EntityKineticBullet> TYPE = EntityType.Builder.m_20704_(EntityKineticBullet::new, (MobCategory)MobCategory.MISC).m_20698_().m_20716_().m_20719_().m_20699_(0.0625f, 0.0625f).m_20702_(5).m_20717_(5).setShouldReceiveVelocityUpdates(false).m_20712_("bullet");
    public static final TagKey<EntityType<?>> USE_MAGIC_DAMAGE_ON = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("tacz:use_magic_damage_on"));
    public static final TagKey<EntityType<?>> USE_VOID_DAMAGE_ON = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("tacz:use_void_damage_on"));
    public static final TagKey<EntityType<?>> PRETEND_MELEE_DAMAGE_ON = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("tacz:pretend_melee_damage_on"));
    public static final String TRACER_COLOR_OVERRIDER_KEY = "tacz:tracer_override";
    public static final String TRACER_SIZE_OVERRIDER_KEY = "tacz:tracer_size";
    private ResourceLocation ammoId = DefaultAssets.EMPTY_AMMO_ID;
    private int life = 200;
    private float speed = 1.0f;
    private float gravity = 0.0f;
    private float friction = 0.01f;
    private LinkedList<ExtraDamage.DistanceDamagePair> damageAmount = Lists.newLinkedList();
    private float distanceAmount = 0.0f;
    private float knockback = 0.0f;
    private boolean explosion = false;
    private boolean igniteEntity = false;
    private boolean igniteBlock = false;
    private int igniteEntityTime = 2;
    private float explosionDamage = 3.0f;
    private float explosionRadius = 3.0f;
    private int explosionDelayCount = Integer.MAX_VALUE;
    private boolean explosionKnockback = false;
    private boolean explosionDestroyBlock = false;
    private float damageModifier = 1.0f;
    private int pierce = 1;
    private Vec3 startPos;
    private boolean isTracerAmmo;
    private float cameraXRot;
    private float cameraYRot;
    private Vector3f firstPersonRenderOffset;
    private ResourceLocation gunId;
    private ResourceLocation gunDisplayId;
    private float armorIgnore;
    private float headShot;

    public EntityKineticBullet(EntityType<? extends Projectile> type, Level worldIn) {
        super(type, worldIn);
    }

    public EntityKineticBullet(EntityType<? extends Projectile> type, double x, double y, double z, Level worldIn) {
        this(type, worldIn);
        this.m_6034_(x, y, z);
    }

    public EntityKineticBullet(Level worldIn, LivingEntity throwerIn, ItemStack gunItem, ResourceLocation ammoId, ResourceLocation gunId, ResourceLocation gunDisplayId, boolean isTracerAmmo, GunData gunData, BulletData bulletData) {
        this(TYPE, worldIn, throwerIn, gunItem, ammoId, gunId, gunDisplayId, isTracerAmmo, gunData, bulletData);
    }

    public EntityKineticBullet(Level worldIn, LivingEntity throwerIn, ItemStack gunItem, ResourceLocation ammoId, ResourceLocation gunId, boolean isTracerAmmo, GunData gunData, BulletData bulletData) {
        this(TYPE, worldIn, throwerIn, gunItem, ammoId, gunId, DefaultAssets.DEFAULT_GUN_DISPLAY_ID, isTracerAmmo, gunData, bulletData);
    }

    protected EntityKineticBullet(EntityType<? extends Projectile> type, Level worldIn, LivingEntity throwerIn, ItemStack gunItem, ResourceLocation ammoId, ResourceLocation gunId, ResourceLocation gunDisplayId, boolean isTracerAmmo, GunData gunData, BulletData bulletData) {
        this(type, throwerIn.m_20185_(), throwerIn.m_20188_() - (double)0.1f, throwerIn.m_20189_(), worldIn);
        this.m_5602_((Entity)throwerIn);
        AttachmentCacheProperty cacheProperty = Objects.requireNonNull(IGunOperator.fromLivingEntity(throwerIn).getCacheProperty());
        this.armorIgnore = Mth.m_14036_((float)((Float)cacheProperty.getCache(ArmorIgnoreModifier.ID)).floatValue(), (float)0.0f, (float)1.0f);
        this.headShot = Math.max(((Float)cacheProperty.getCache(HeadShotModifier.ID)).floatValue(), 0.0f);
        this.knockback = Math.max(((Float)cacheProperty.getCache(KnockbackModifier.ID)).floatValue(), 0.0f);
        this.ammoId = ammoId;
        this.life = Mth.m_14045_((int)((int)(bulletData.getLifeSecond() * 20.0f)), (int)1, (int)Integer.MAX_VALUE);
        this.speed = Mth.m_14036_((float)(((Float)cacheProperty.getCache(AmmoSpeedModifier.ID)).floatValue() / 20.0f), (float)0.0f, (float)30.0f);
        this.gravity = Mth.m_14036_((float)bulletData.getGravity(), (float)0.0f, (float)Float.MAX_VALUE);
        this.friction = Mth.m_14036_((float)bulletData.getFriction(), (float)0.0f, (float)Float.MAX_VALUE);
        Ignite ignite = (Ignite)cacheProperty.getCache(IgniteModifier.ID);
        this.igniteEntity = bulletData.getIgnite().isIgniteEntity() || ignite.isIgniteEntity();
        this.igniteEntityTime = Math.max(bulletData.getIgniteEntityTime(), 0);
        this.igniteBlock = bulletData.getIgnite().isIgniteBlock() || ignite.isIgniteBlock();
        this.damageAmount = (LinkedList)cacheProperty.getCache(DamageModifier.ID);
        this.distanceAmount = ((Float)cacheProperty.getCache(EffectiveRangeModifier.ID)).floatValue();
        if (bulletData.getBulletAmount() > 1) {
            this.damageModifier = 1.0f / (float)bulletData.getBulletAmount();
        }
        this.pierce = Mth.m_14045_((int)((Integer)cacheProperty.getCache(PierceModifier.ID)), (int)1, (int)Integer.MAX_VALUE);
        ExplosionData explosionData = (ExplosionData)cacheProperty.getCache(ExplosionModifier.ID);
        if (explosionData != null) {
            this.explosion = explosionData.isExplode();
            this.explosionDamage = (float)Mth.m_14008_((double)((double)explosionData.getDamage() * (Double)SyncConfig.DAMAGE_BASE_MULTIPLIER.get()), (double)0.0, (double)3.4028234663852886E38);
            this.explosionRadius = Mth.m_14036_((float)explosionData.getRadius(), (float)0.0f, (float)Float.MAX_VALUE);
            this.explosionKnockback = explosionData.isKnockback();
            int delayTickCount = explosionData.getDelay() * 20;
            if (delayTickCount < 0) {
                delayTickCount = Integer.MAX_VALUE;
            }
            this.explosionDestroyBlock = explosionData.isDestroyBlock() && (Boolean)AmmoConfig.EXPLOSIVE_AMMO_DESTROYS_BLOCK.get() != false;
            this.explosionDelayCount = Math.max(delayTickCount, 1);
        }
        double posX = throwerIn.f_19790_ + (throwerIn.m_20185_() - throwerIn.f_19790_) / 2.0;
        double posY = throwerIn.f_19791_ + (throwerIn.m_20186_() - throwerIn.f_19791_) / 2.0 + (double)throwerIn.m_20192_();
        double posZ = throwerIn.f_19792_ + (throwerIn.m_20189_() - throwerIn.f_19792_) / 2.0;
        this.m_6034_(posX, posY, posZ);
        this.startPos = this.m_20182_();
        this.isTracerAmmo = isTracerAmmo;
        this.gunId = gunId;
        this.gunDisplayId = gunDisplayId;
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        super.m_8119_();
        this.onBulletTick();
        if (this.m_9236_().f_46443_) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> AmmoParticleSpawner.addParticle(this));
        }
        Vec3 movement = this.m_20184_();
        double x = movement.f_82479_;
        double y = movement.f_82480_;
        double z = movement.f_82481_;
        double distance = movement.m_165924_();
        this.m_146922_((float)Math.toDegrees(Mth.m_14136_((double)x, (double)z)));
        this.m_146926_((float)Math.toDegrees(Mth.m_14136_((double)y, (double)distance)));
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
        this.m_146926_(EntityKineticBullet.m_37273_((float)this.f_19860_, (float)this.m_146909_()));
        this.m_146922_(EntityKineticBullet.m_37273_((float)this.f_19859_, (float)this.m_146908_()));
        double nextPosX = this.m_20185_() + x;
        double nextPosY = this.m_20186_() + y;
        double nextPosZ = this.m_20189_() + z;
        this.m_6034_(nextPosX, nextPosY, nextPosZ);
        float friction = this.friction;
        float gravity = this.gravity;
        if (this.m_20069_()) {
            for (int i = 0; i < 4; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, nextPosX - x * 0.25, nextPosY - y * 0.25, nextPosZ - z * 0.25, x, y, z);
            }
            friction = 0.4f;
            gravity *= 0.6f;
        }
        this.m_20256_(this.m_20184_().m_82490_((double)(1.0f - friction)));
        this.m_20256_(this.m_20184_().m_82520_(0.0, (double)(-gravity), 0.0));
        if (this.f_19797_ >= this.life - 1) {
            this.m_146870_();
        }
    }

    protected void onBulletTick() {
        if (!this.m_9236_().m_5776_()) {
            if (this.explosion) {
                if (this.explosionDelayCount > 0) {
                    --this.explosionDelayCount;
                } else {
                    ExplodeUtil.createExplosion(this.m_19749_(), (Entity)this, this.explosionDamage, this.explosionRadius, this.explosionKnockback, this.explosionDestroyBlock, this.m_20182_());
                    this.m_146870_();
                    return;
                }
            }
            Vec3 startVec = this.m_20182_();
            Vec3 endVec = startVec.m_82549_(this.m_20184_());
            Object result = BlockRayTrace.rayTraceBlocks(this.m_9236_(), new ClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            BlockHitResult resultB = result;
            if (resultB.m_6662_() != HitResult.Type.MISS) {
                endVec = resultB.m_82450_();
            }
            List<EntityResult> hitEntities = null;
            if (this.pierce <= 1 || this.explosion) {
                EntityResult entityResult = EntityUtil.findEntityOnPath(this, startVec, endVec);
                if (entityResult != null) {
                    hitEntities = Collections.singletonList(entityResult);
                }
            } else {
                hitEntities = EntityUtil.findEntitiesOnPath(this, startVec, endVec);
            }
            if (hitEntities != null && !hitEntities.isEmpty()) {
                EntityResult[] hitEntityResult = hitEntities.toArray(new EntityResult[0]);
                for (int i = 0; (i < this.pierce || i < 1) && i < hitEntityResult.length - 1; ++i) {
                    int k = i;
                    for (int j = i + 1; j < hitEntityResult.length; ++j) {
                        if (!(hitEntityResult[j].hitVec.m_82554_(startVec) < hitEntityResult[k].hitVec.m_82554_(startVec))) continue;
                        k = j;
                    }
                    EntityResult t = hitEntityResult[i];
                    hitEntityResult[i] = hitEntityResult[k];
                    hitEntityResult[k] = t;
                }
                for (EntityResult entityResult : hitEntityResult) {
                    result = new TacHitResult(entityResult);
                    this.onHitEntity((TacHitResult)((Object)result), startVec, endVec);
                    --this.pierce;
                    if (this.pierce >= 1 && !this.explosion) continue;
                    this.m_146870_();
                    return;
                }
            }
            this.onHitBlock(resultB, startVec, endVec);
        }
    }

    public void shoot(double pitch, double yaw, float pVelocity, Vector2d vector2d) {
        Vector3d left = new Vector3d(vector2d.x, vector2d.y, 8.0);
        left.rotateX(pitch * 0.01745329238474369);
        left.rotateY(-yaw * 0.01745329238474369);
        Vec3 vec3 = new Vec3(left.x, left.y, left.z).m_82541_().m_82490_((double)pVelocity);
        this.m_20334_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        double d0 = vec3.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    public void shootFromRotation(Entity pShooter, float pX, float pY, float pZ, float pVelocity, Vector2d vector2d) {
        this.shoot(pX, pY, pVelocity, vector2d);
        Vec3 vec3 = pShooter.m_20184_();
        this.m_20256_(this.m_20184_().m_82520_(vec3.f_82479_, pShooter.m_20096_() ? 0.0 : vec3.f_82480_, vec3.f_82481_));
    }

    protected void onHitEntity(TacHitResult result, Vec3 startVec, Vec3 endVec) {
        KnockBackModifier modifier;
        LivingEntity livingCore;
        Entity entity;
        float headShotMultiplier;
        Entity entity2 = result.m_82443_();
        if (entity2 instanceof ITargetEntity) {
            ITargetEntity targetEntity = (ITargetEntity)entity2;
            DamageSource source = this.m_269291_().m_269390_((Entity)this, this.m_19749_());
            targetEntity.onProjectileHit((Entity)this, result, source, this.getDamage(result.m_82450_()));
            return;
        }
        Entity entity3 = result.m_82443_();
        @Nullable Entity owner = this.m_19749_();
        LivingEntity attacker = owner instanceof LivingEntity ? (LivingEntity)owner : null;
        Pair sources = this.createDamageSources(MaybeMultipartEntity.of(entity3));
        boolean headshot = result.isHeadshot();
        float damage = this.getDamage(result.m_82450_());
        EntityHurtByGunEvent.Pre preEvent = new EntityHurtByGunEvent.Pre((Entity)this, entity3, attacker, this.gunId, this.gunDisplayId, damage, sources, headshot, headShotMultiplier = Math.max(this.headShot, 0.0f), LogicalSide.SERVER);
        boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)preEvent);
        if (cancelled) {
            return;
        }
        entity3 = preEvent.getHurtEntity();
        MaybeMultipartEntity parts = MaybeMultipartEntity.of(entity3);
        attacker = preEvent.getAttacker();
        ResourceLocation newGunId = preEvent.getGunId();
        damage = preEvent.getBaseAmount();
        sources = Pair.of((Object)preEvent.getDamageSource(GunDamageSourcePart.NON_ARMOR_PIERCING), (Object)preEvent.getDamageSource(GunDamageSourcePart.ARMOR_PIERCING));
        headshot = preEvent.isHeadShot();
        headShotMultiplier = preEvent.getHeadshotMultiplier();
        if (entity3 == null) {
            return;
        }
        if (this.igniteEntity && ((Boolean)AmmoConfig.IGNITE_ENTITY.get()).booleanValue()) {
            entity3.m_20254_(this.igniteEntityTime);
            entity = this.m_9236_();
            if (entity instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)entity;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123756_, entity3.m_20185_(), entity3.m_20186_() + (double)entity3.m_20192_(), entity3.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        if (headshot) {
            damage *= headShotMultiplier;
        }
        if ((entity = parts.core()) instanceof LivingEntity) {
            livingCore = (LivingEntity)entity;
            modifier = KnockBackModifier.fromLivingEntity(livingCore);
            modifier.setKnockBackStrength(this.knockback);
            this.tacAttackEntity(parts, damage, (Pair<DamageSource, DamageSource>)sources);
            modifier.resetKnockBackStrength();
        } else {
            this.tacAttackEntity(parts, damage, (Pair<DamageSource, DamageSource>)sources);
        }
        if (this.explosion) {
            parts.core().f_19802_ = 0;
            ExplodeUtil.createExplosion(this.m_19749_(), (Entity)this, this.explosionDamage, this.explosionRadius, this.explosionKnockback, this.explosionDestroyBlock, result.m_82450_());
        }
        if ((modifier = parts.core()) instanceof LivingEntity) {
            livingCore = (LivingEntity)modifier;
            if (!this.m_9236_().f_46443_) {
                int attackerId;
                int n = attackerId = attacker == null ? 0 : attacker.m_19879_();
                if (livingCore.m_21224_()) {
                    MinecraftForge.EVENT_BUS.post((Event)new EntityKillByGunEvent((Entity)this, livingCore, attacker, newGunId, this.gunDisplayId, damage, (Pair<DamageSource, DamageSource>)sources, headshot, headShotMultiplier, LogicalSide.SERVER));
                    NetworkHandler.sendToDimension(new ServerMessageGunKill(this.m_19879_(), livingCore.m_19879_(), attackerId, newGunId, this.gunDisplayId, damage, headshot, headShotMultiplier), (Entity)livingCore);
                } else {
                    MinecraftForge.EVENT_BUS.post((Event)new EntityHurtByGunEvent.Post((Entity)this, (Entity)livingCore, attacker, newGunId, this.gunDisplayId, damage, (Pair<DamageSource, DamageSource>)sources, headshot, headShotMultiplier, LogicalSide.SERVER));
                    NetworkHandler.sendToDimension(new ServerMessageGunHurt(this.m_19879_(), livingCore.m_19879_(), attackerId, newGunId, this.gunDisplayId, damage, headshot, headShotMultiplier), (Entity)livingCore);
                }
            }
        }
    }

    protected void onHitBlock(BlockHitResult result, Vec3 startVec, Vec3 endVec) {
        if (result.m_6662_() == HitResult.Type.MISS) {
            return;
        }
        BlockPos pos = result.m_82425_();
        Vec3 hitVec = result.m_82450_();
        if (MinecraftForge.EVENT_BUS.post((Event)new AmmoHitBlockEvent(this.m_9236_(), result, this.m_9236_().m_8055_(pos), this))) {
            return;
        }
        super.m_8060_(result);
        if (this.explosion) {
            ExplodeUtil.createExplosion(this.m_19749_(), (Entity)this, this.explosionDamage, this.explosionRadius, this.explosionKnockback, this.explosionDestroyBlock, hitVec);
            this.m_146870_();
            return;
        }
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BulletHoleOption bulletHoleOption = new BulletHoleOption(result.m_82434_(), result.m_82425_(), this.ammoId.toString(), this.gunId.toString(), this.gunDisplayId.toString());
            serverLevel.m_8767_((ParticleOptions)bulletHoleOption, hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            if (this.igniteBlock) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123756_, hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        if (this.igniteBlock && ((Boolean)AmmoConfig.IGNITE_BLOCK.get()).booleanValue()) {
            BlockPos offsetPos = pos.m_121945_(result.m_82434_());
            if (BaseFireBlock.m_49255_((Level)this.m_9236_(), (BlockPos)offsetPos, (Direction)result.m_82434_())) {
                BlockState fireState = BaseFireBlock.m_49245_((BlockGetter)this.m_9236_(), (BlockPos)offsetPos);
                this.m_9236_().m_7731_(offsetPos, fireState, 11);
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123756_, hitVec.f_82479_ - 1.0 + this.f_19796_.m_188500_() * 2.0, hitVec.f_82480_, hitVec.f_82481_ - 1.0 + this.f_19796_.m_188500_() * 2.0, 4, 0.0, 0.0, 0.0, 0.0);
            }
        }
        this.m_146870_();
    }

    public float getDamage(Vec3 hitVec) {
        double playerDistance = hitVec.m_82554_(this.startPos);
        for (ExtraDamage.DistanceDamagePair pair : this.damageAmount) {
            float f = this.damageAmount.get(0).getDistance() == pair.getDistance() ? this.distanceAmount : pair.getDistance();
            float effectiveDistance = f;
            if (!(playerDistance < (double)effectiveDistance)) continue;
            float damage = pair.getDamage();
            return Math.max(damage * this.damageModifier, 0.0f);
        }
        return 0.0f;
    }

    private Pair<DamageSource, DamageSource> createDamageSources(MaybeMultipartEntity parts) {
        DamageSource source1;
        DamageSource source2;
        EntityKineticBullet directCause;
        EntityType hitPartType = parts.hitPart().m_6095_();
        EntityKineticBullet entityKineticBullet = directCause = hitPartType.m_204039_(PRETEND_MELEE_DAMAGE_ON) ? this.m_19749_() : this;
        if (hitPartType.m_204039_(USE_MAGIC_DAMAGE_ON)) {
            source1 = source2 = this.m_269291_().m_269104_((Entity)this, this.m_19749_());
        } else if (hitPartType.m_204039_(USE_VOID_DAMAGE_ON)) {
            source1 = ModDamageTypes.Sources.bulletVoid(this.m_9236_().m_9598_(), (Entity)directCause, this.m_19749_(), false);
            source2 = ModDamageTypes.Sources.bulletVoid(this.m_9236_().m_9598_(), (Entity)directCause, this.m_19749_(), true);
        } else {
            source1 = ModDamageTypes.Sources.bullet(this.m_9236_().m_9598_(), (Entity)directCause, this.m_19749_(), false);
            source2 = ModDamageTypes.Sources.bullet(this.m_9236_().m_9598_(), (Entity)directCause, this.m_19749_(), true);
        }
        return Pair.of((Object)source1, (Object)source2);
    }

    private void tacAttackEntity(MaybeMultipartEntity parts, float damage, Pair<DamageSource, DamageSource> sources) {
        DamageSource source1 = (DamageSource)sources.getLeft();
        DamageSource source2 = (DamageSource)sources.getRight();
        float armorDamagePercent = Mth.m_14036_((float)this.armorIgnore, (float)0.0f, (float)1.0f);
        float normalDamagePercent = 1.0f - armorDamagePercent;
        parts.core().f_19802_ = 0;
        parts.hitPart().m_6469_(source1, damage * normalDamagePercent);
        parts.core().f_19802_ = 0;
        parts.hitPart().m_6469_(source2, damage * armorDamagePercent);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.m_146909_());
        buffer.writeFloat(this.m_146908_());
        buffer.writeDouble(this.m_20184_().f_82479_);
        buffer.writeDouble(this.m_20184_().f_82480_);
        buffer.writeDouble(this.m_20184_().f_82481_);
        Entity entity = this.m_19749_();
        buffer.writeInt(entity != null ? entity.m_19879_() : 0);
        buffer.m_130085_(this.ammoId);
        buffer.writeFloat(this.gravity);
        buffer.writeBoolean(this.explosion);
        buffer.writeBoolean(this.igniteEntity);
        buffer.writeBoolean(this.igniteBlock);
        buffer.writeFloat(this.explosionRadius);
        buffer.writeFloat(this.explosionDamage);
        buffer.writeInt(this.life);
        buffer.writeFloat(this.speed);
        buffer.writeFloat(this.friction);
        buffer.writeInt(this.pierce);
        buffer.writeBoolean(this.isTracerAmmo);
        buffer.m_130085_(this.gunId);
        buffer.m_130085_(this.gunDisplayId);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.m_146926_(additionalData.readFloat());
        this.m_146922_(additionalData.readFloat());
        this.m_20334_(additionalData.readDouble(), additionalData.readDouble(), additionalData.readDouble());
        Entity entity = this.m_9236_().m_6815_(additionalData.readInt());
        if (entity != null) {
            this.m_5602_(entity);
        }
        this.ammoId = additionalData.m_130281_();
        this.gravity = additionalData.readFloat();
        this.explosion = additionalData.readBoolean();
        this.igniteEntity = additionalData.readBoolean();
        this.igniteBlock = additionalData.readBoolean();
        this.explosionRadius = additionalData.readFloat();
        this.explosionDamage = additionalData.readFloat();
        this.life = additionalData.readInt();
        this.speed = additionalData.readFloat();
        this.friction = additionalData.readFloat();
        this.pierce = additionalData.readInt();
        this.isTracerAmmo = additionalData.readBoolean();
        this.gunId = additionalData.m_130281_();
        this.gunDisplayId = additionalData.m_130281_();
    }

    public ResourceLocation getAmmoId() {
        return this.ammoId;
    }

    public ResourceLocation getGunId() {
        return this.gunId;
    }

    public ResourceLocation getGunDisplayId() {
        return this.gunDisplayId;
    }

    public boolean isTracerAmmo() {
        return this.isTracerAmmo;
    }

    public RandomSource getRandom() {
        return this.f_19796_;
    }

    public float getCameraYRot() {
        return this.cameraYRot;
    }

    public void setCameraYRot(float cameraYRot) {
        this.cameraYRot = cameraYRot;
    }

    public float getCameraXRot() {
        return this.cameraXRot;
    }

    public void setCameraXRot(float cameraXRot) {
        this.cameraXRot = cameraXRot;
    }

    public Vector3f getFirstPersonRenderOffset() {
        return this.firstPersonRenderOffset;
    }

    public void setFirstPersonRenderOffset(Vector3f originRenderOffset) {
        this.firstPersonRenderOffset = originRenderOffset;
    }

    public Optional<float[]> getTracerColorOverride() {
        CompoundTag pd = this.getPersistentData();
        if (!pd.m_128425_(TRACER_COLOR_OVERRIDER_KEY, 11)) {
            return Optional.empty();
        }
        int[] ints = pd.m_128465_(TRACER_COLOR_OVERRIDER_KEY);
        switch (ints.length) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                float albedo = (float)ints[0] / 255.0f;
                return Optional.of(new float[]{albedo, albedo, albedo, 1.0f});
            }
            case 2: {
                float albedo = (float)ints[0] / 255.0f;
                float alpha = (float)ints[1] / 255.0f;
                return Optional.of(new float[]{albedo, albedo, albedo, alpha});
            }
            case 3: {
                float r = (float)ints[0] / 255.0f;
                float g = (float)ints[1] / 255.0f;
                float b = (float)ints[2] / 255.0f;
                return Optional.of(new float[]{r, g, b, 1.0f});
            }
        }
        float r = (float)ints[0] / 255.0f;
        float g = (float)ints[1] / 255.0f;
        float b = (float)ints[2] / 255.0f;
        float a = (float)ints[3] / 255.0f;
        return Optional.of(new float[]{r, g, b, a});
    }

    public float getTracerSizeOverride() {
        CompoundTag pd = this.getPersistentData();
        return pd.m_128425_(TRACER_SIZE_OVERRIDER_KEY, 99) ? pd.m_128457_(TRACER_SIZE_OVERRIDER_KEY) : 1.0f;
    }

    public boolean m_150171_(@Nullable Entity entity) {
        if (entity == null) {
            return false;
        }
        return super.m_150171_(entity);
    }

    public static class EntityResult {
        private final Entity entity;
        private final Vec3 hitVec;
        private final boolean headshot;

        public EntityResult(Entity entity, Vec3 hitVec, boolean headshot) {
            this.entity = entity;
            this.hitVec = hitVec;
            this.headshot = headshot;
        }

        public Entity getEntity() {
            return this.entity;
        }

        public Vec3 getHitPos() {
            return this.hitVec;
        }

        public boolean isHeadshot() {
            return this.headshot;
        }
    }

    public record MaybeMultipartEntity(Entity hitPart, Entity core) {
        public static MaybeMultipartEntity of(Entity hitPart) {
            Entity entity;
            if (hitPart instanceof PartEntity) {
                PartEntity part = (PartEntity)hitPart;
                entity = part.getParent();
            } else {
                entity = hitPart;
            }
            Entity core = entity;
            return new MaybeMultipartEntity(hitPart, core);
        }
    }
}

