/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.item;

import com.google.common.base.Suppliers;
import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.ReloadState;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.api.item.nbt.GunItemDataAccessor;
import com.tacz.guns.command.sub.DebugCommand;
import com.tacz.guns.debug.GunMeleeDebug;
import com.tacz.guns.entity.EntityKineticBullet;
import com.tacz.guns.entity.shooter.ShooterDataHolder;
import com.tacz.guns.item.ModernKineticGunScriptAPI;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.pojo.data.attachment.EffectData;
import com.tacz.guns.resource.pojo.data.attachment.MeleeData;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource.pojo.data.gun.GunDefaultMeleeData;
import com.tacz.guns.resource.pojo.data.gun.GunHeatData;
import com.tacz.guns.resource.pojo.data.gun.GunMeleeData;
import com.tacz.guns.resource.pojo.data.gun.GunReloadData;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.DoubleFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Vector2d;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;

public class ModernKineticGunItem
extends AbstractGunItem
implements GunItemDataAccessor {
    public static final String TYPE_NAME = "modern_kinetic";
    private static final DoubleFunction<AttributeModifier> AM_FACTORY = amount -> new AttributeModifier(UUID.randomUUID(), "TACZ Melee Damage", amount, AttributeModifier.Operation.ADDITION);

    public ModernKineticGunItem() {
        super(new Item.Properties().m_41487_(1));
    }

    @Override
    public boolean startBolt(ShooterDataHolder dataHolder, ItemStack gunItem, LivingEntity shooter) {
        ModernKineticGunScriptAPI api = new ModernKineticGunScriptAPI();
        api.setItemStack(gunItem);
        api.setShooter(shooter);
        api.setDataHolder(dataHolder);
        CommonGunIndex gunIndex = api.getGunIndex();
        if (gunIndex == null) {
            return false;
        }
        return Optional.ofNullable(gunIndex.getScript()).map(script -> this.checkFunction(script.get("start_bolt"))).map(func -> func.call(CoerceJavaToLua.coerce((Object)api)).checkboolean()).orElse(true);
    }

    @Override
    public boolean tickBolt(ShooterDataHolder dataHolder, ItemStack gunItem, LivingEntity shooter) {
        ModernKineticGunScriptAPI api = new ModernKineticGunScriptAPI();
        api.setItemStack(gunItem);
        api.setShooter(shooter);
        api.setDataHolder(dataHolder);
        CommonGunIndex gunIndex = api.getGunIndex();
        if (gunIndex == null) {
            return false;
        }
        return Optional.ofNullable(gunIndex.getScript()).map(script -> this.checkFunction(script.get("tick_bolt"))).map(func -> func.call(CoerceJavaToLua.coerce((Object)api)).checkboolean()).orElseGet(() -> this.defaultTickBolt(api));
    }

    @Override
    public void shoot(ShooterDataHolder dataHolder, ItemStack gunItem, Supplier<Float> pitch, Supplier<Float> yaw, LivingEntity shooter) {
        ModernKineticGunScriptAPI api = new ModernKineticGunScriptAPI();
        api.setItemStack(gunItem);
        api.setShooter(shooter);
        api.setDataHolder(dataHolder);
        api.setPitchSupplier(pitch);
        api.setYawSupplier(yaw);
        CommonGunIndex gunIndex = api.getGunIndex();
        if (gunIndex == null) {
            return;
        }
        Optional.ofNullable(gunIndex.getScript()).map(script -> this.checkFunction(script.get("shoot"))).ifPresentOrElse(func -> func.call(CoerceJavaToLua.coerce((Object)api)), () -> api.shootOnce(api.isShootingNeedConsumeAmmo()));
    }

    @Override
    public boolean startReload(ShooterDataHolder dataHolder, ItemStack gunItem, LivingEntity shooter) {
        ModernKineticGunScriptAPI api = new ModernKineticGunScriptAPI();
        api.setItemStack(gunItem);
        api.setShooter(shooter);
        api.setDataHolder(dataHolder);
        CommonGunIndex gunIndex = api.getGunIndex();
        if (gunIndex == null) {
            return false;
        }
        return Optional.ofNullable(gunIndex.getScript()).map(script -> this.checkFunction(script.get("start_reload"))).map(func -> func.call(CoerceJavaToLua.coerce((Object)api)).checkboolean()).orElse(true);
    }

    @Override
    public ReloadState tickReload(ShooterDataHolder dataHolder, ItemStack gunItem, LivingEntity shooter) {
        ModernKineticGunScriptAPI api = new ModernKineticGunScriptAPI();
        api.setItemStack(gunItem);
        api.setShooter(shooter);
        api.setDataHolder(dataHolder);
        CommonGunIndex gunIndex = api.getGunIndex();
        if (gunIndex == null) {
            return new ReloadState();
        }
        return Optional.ofNullable(gunIndex.getScript()).map(script -> this.checkFunction(script.get("tick_reload"))).map(func -> {
            ReloadState reloadState = new ReloadState();
            Varargs varargs = func.invoke((Varargs)CoerceJavaToLua.coerce((Object)api));
            int typeOrdinary = varargs.arg(1).checkint();
            long countDown = varargs.arg(2).checklong();
            reloadState.setStateType(ReloadState.StateType.values()[typeOrdinary]);
            reloadState.setCountDown(countDown);
            return reloadState;
        }).orElseGet(() -> this.defaultTickReload(api));
    }

    @Override
    public void interruptReload(ShooterDataHolder dataHolder, ItemStack gunItem, LivingEntity shooter) {
        ModernKineticGunScriptAPI api = new ModernKineticGunScriptAPI();
        api.setItemStack(gunItem);
        api.setShooter(shooter);
        api.setDataHolder(dataHolder);
        CommonGunIndex gunIndex = api.getGunIndex();
        if (gunIndex == null) {
            return;
        }
        Optional.ofNullable(gunIndex.getScript()).map(script -> this.checkFunction(script.get("interrupt_reload"))).ifPresent(func -> func.call(CoerceJavaToLua.coerce((Object)api)));
    }

    @Override
    public void melee(ShooterDataHolder dataHolder, LivingEntity user, ItemStack gunItem) {
        ResourceLocation gunId = this.getGunId(gunItem);
        TimelessAPI.getCommonGunIndex(gunId).ifPresent(gunIndex -> {
            GunMeleeData meleeData = gunIndex.getGunData().getMeleeData();
            float distance = meleeData.getDistance();
            ResourceLocation muzzleId = this.getAttachmentId(gunItem, AttachmentType.MUZZLE);
            MeleeData muzzleData = this.getMeleeData(muzzleId);
            if (muzzleData != null) {
                this.doMelee(user, distance, muzzleData.getDistance(), muzzleData.getRangeAngle(), muzzleData.getKnockback(), muzzleData.getDamage(), muzzleData.getEffects());
                return;
            }
            ResourceLocation stockId = this.getAttachmentId(gunItem, AttachmentType.STOCK);
            MeleeData stockData = this.getMeleeData(stockId);
            if (stockData != null) {
                this.doMelee(user, distance, stockData.getDistance(), stockData.getRangeAngle(), stockData.getKnockback(), stockData.getDamage(), stockData.getEffects());
                return;
            }
            GunDefaultMeleeData defaultData = meleeData.getDefaultMeleeData();
            if (defaultData == null) {
                return;
            }
            this.doMelee(user, distance, defaultData.getDistance(), defaultData.getRangeAngle(), defaultData.getKnockback(), defaultData.getDamage(), Collections.emptyList());
        });
    }

    @Override
    public void tickHeat(ShooterDataHolder dataHolder, ItemStack gunItem, LivingEntity shooter) {
        ModernKineticGunScriptAPI api = new ModernKineticGunScriptAPI();
        api.setItemStack(gunItem);
        api.setShooter(shooter);
        api.setDataHolder(dataHolder);
        long heatTimestamp = dataHolder.heatTimestamp;
        CommonGunIndex gunIndex = api.getGunIndex();
        if (gunIndex == null) {
            return;
        }
        Optional.ofNullable(gunIndex.getScript()).map(script -> this.checkFunction(script.get("tick_heat"))).ifPresentOrElse(func -> func.call(CoerceJavaToLua.coerce((Object)api), (LuaValue)LuaValue.valueOf((double)heatTimestamp)), () -> this.defaultTickHeat(heatTimestamp, gunItem));
    }

    private void defaultTickHeat(long heatTimestamp, ItemStack gunItem) {
        IGun iGun = IGun.getIGunOrNull(gunItem);
        if (iGun == null) {
            return;
        }
        TimelessAPI.getCommonGunIndex(iGun.getGunId(gunItem)).map(index -> index.getGunData().getHeatData()).ifPresent(heatData -> {
            if (iGun.getHeatAmount(gunItem) <= 0.0f) {
                return;
            }
            if (iGun.isOverheatLocked(gunItem)) {
                this.tickLocked(iGun, gunItem, (GunHeatData)heatData, heatTimestamp);
            } else {
                this.tickNormal(iGun, gunItem, (GunHeatData)heatData, heatTimestamp);
            }
        });
    }

    public void tickLocked(IGun iGun, ItemStack gunStack, GunHeatData heatData, long heatTimestamp) {
        if (System.currentTimeMillis() - heatTimestamp >= heatData.getOverHeatTime()) {
            float heatAmount = iGun.getHeatAmount(gunStack) - (float)(System.currentTimeMillis() - heatTimestamp) / 10000.0f * heatData.getCoolingMultiplier();
            iGun.setHeatAmount(gunStack, heatAmount);
            if (heatAmount <= 0.0f) {
                iGun.setOverheatLocked(gunStack, false);
            }
        }
    }

    public void tickNormal(IGun iGun, ItemStack gunStack, GunHeatData heatData, long heatTimestamp) {
        if (System.currentTimeMillis() - heatTimestamp >= heatData.getCoolingDelay()) {
            float heatAmount = iGun.getHeatAmount(gunStack) - (float)(System.currentTimeMillis() - heatTimestamp) / 10000.0f * heatData.getCoolingMultiplier();
            iGun.setHeatAmount(gunStack, heatAmount);
        }
    }

    @Override
    public void doBulletSpread(ShooterDataHolder dataHolder, ItemStack gunItem, LivingEntity shooter, Projectile projectile, int bulletCnt, float processedSpeed, float inaccuracy, float pitch, float yaw) {
        if (!(projectile instanceof EntityKineticBullet)) {
            return;
        }
        EntityKineticBullet bullet = (EntityKineticBullet)projectile;
        ModernKineticGunScriptAPI api = new ModernKineticGunScriptAPI();
        api.setItemStack(gunItem);
        api.setShooter(shooter);
        api.setDataHolder(dataHolder);
        CommonGunIndex gunIndex = api.getGunIndex();
        if (gunIndex == null) {
            return;
        }
        Optional.ofNullable(gunIndex.getScript()).map(script -> this.checkFunction(script.get("calcSpread"))).map(func -> func.call(CoerceJavaToLua.coerce((Object)api), (LuaValue)LuaValue.valueOf((int)bulletCnt), (LuaValue)LuaValue.valueOf((double)inaccuracy))).map(luaValue -> {
            if (luaValue.istable()) {
                LuaTable table = luaValue.checktable();
                return new Vector2d(table.get(1).checkdouble(), table.get(2).checkdouble());
            }
            return null;
        }).ifPresentOrElse(vector2d -> bullet.shootFromRotation((Entity)bullet, pitch, yaw, 0.0f, processedSpeed, (Vector2d)vector2d), () -> bullet.m_37251_((Entity)bullet, pitch, yaw, 0.0f, processedSpeed, inaccuracy));
    }

    private boolean defaultTickBolt(ModernKineticGunScriptAPI api) {
        long boltFeedTime;
        GunData gunData = api.getGunIndex().getGunData();
        long boltActionTime = (long)(gunData.getBoltActionTime() * 1000.0f);
        float rawBoltFeedTime = gunData.getBoltFeedTime();
        long l = boltFeedTime = rawBoltFeedTime == -1.0f ? boltActionTime : (long)(gunData.getBoltFeedTime() * 1000.0f);
        if (api.getBoltTime() < boltFeedTime) {
            return true;
        }
        if (!api.hasAmmoInBarrel()) {
            if (api.useInventoryAmmo()) {
                if (api.consumeAmmoFromPlayer(1) == 1) {
                    api.setAmmoInBarrel(true);
                }
            } else if (api.removeAmmoFromMagazine(1) != 0) {
                api.setAmmoInBarrel(true);
            }
        }
        return api.getBoltTime() < boltActionTime;
    }

    private ReloadState defaultTickReload(ModernKineticGunScriptAPI api) {
        long countDown;
        ReloadState.StateType stateType;
        CommonGunIndex gunIndex = api.getGunIndex();
        GunData gunData = gunIndex.getGunData();
        GunReloadData reloadData = gunData.getReloadData();
        ReloadState.StateType oldStateType = ReloadState.StateType.values()[api.getReloadStateType()];
        long progressTime = api.getReloadTime();
        if (oldStateType.isReloadingEmpty()) {
            feedTime = (long)(reloadData.getFeed().getEmptyTime() * 1000.0f);
            long finishingTime = (long)(reloadData.getCooldown().getEmptyTime() * 1000.0f);
            if (progressTime < feedTime) {
                stateType = ReloadState.StateType.EMPTY_RELOAD_FEEDING;
                countDown = feedTime - progressTime;
            } else if (progressTime < finishingTime) {
                stateType = ReloadState.StateType.EMPTY_RELOAD_FINISHING;
                countDown = finishingTime - progressTime;
            } else {
                stateType = ReloadState.StateType.NOT_RELOADING;
                countDown = -1L;
            }
        } else if (oldStateType.isReloadingTactical()) {
            feedTime = (long)(reloadData.getFeed().getTacticalTime() * 1000.0f);
            long finishingTime = (long)(reloadData.getCooldown().getTacticalTime() * 1000.0f);
            if (progressTime < feedTime) {
                stateType = ReloadState.StateType.TACTICAL_RELOAD_FEEDING;
                countDown = feedTime - progressTime;
            } else if (progressTime < finishingTime) {
                stateType = ReloadState.StateType.TACTICAL_RELOAD_FINISHING;
                countDown = finishingTime - progressTime;
            } else {
                stateType = ReloadState.StateType.NOT_RELOADING;
                countDown = -1L;
            }
        } else {
            stateType = ReloadState.StateType.NOT_RELOADING;
            countDown = -1L;
        }
        if (oldStateType == ReloadState.StateType.EMPTY_RELOAD_FEEDING && oldStateType != stateType) {
            this.defaultReloadFinishing(api, false);
        }
        if (oldStateType == ReloadState.StateType.TACTICAL_RELOAD_FEEDING && oldStateType != stateType) {
            this.defaultReloadFinishing(api, true);
        }
        ReloadState reloadState = new ReloadState();
        reloadState.setStateType(stateType);
        reloadState.setCountDown(countDown);
        return reloadState;
    }

    private void defaultReloadFinishing(ModernKineticGunScriptAPI api, boolean isTactical) {
        int i;
        GunData data = api.getGunIndex().getGunData();
        int needAmmoCount = api.getNeededAmmoAmount();
        boolean needConsumeAmmo = api.isReloadingNeedConsumeAmmo();
        boolean infinite = data.getReloadData().isInfinite();
        needConsumeAmmo = needConsumeAmmo || infinite;
        switch (data.getReloadData().getType()) {
            case MAGAZINE: {
                int consumedAmount;
                if (needConsumeAmmo) {
                    consumedAmount = api.consumeAmmoFromPlayer(needAmmoCount);
                    api.putAmmoInMagazine(consumedAmount);
                    break;
                }
                api.putAmmoInMagazine(needAmmoCount);
                break;
            }
            case FUEL: {
                int consumedAmount;
                if (needConsumeAmmo) {
                    consumedAmount = api.consumeAmmoFromPlayer(1);
                    api.putAmmoInMagazine(needAmmoCount * consumedAmount);
                    break;
                }
                api.putAmmoInMagazine(needAmmoCount);
                break;
            }
        }
        Bolt boltType = api.getGunIndex().getGunData().getBolt();
        if (!(isTactical || boltType != Bolt.MANUAL_ACTION && boltType != Bolt.CLOSED_BOLT || (i = api.removeAmmoFromMagazine(1)) == 0)) {
            api.setAmmoInBarrel(true);
        }
    }

    private void doMelee(LivingEntity user, float gunDistance, float meleeDistance, float rangeAngle, float knockback, float damage, List<EffectData> effects) {
        double distance = gunDistance + meleeDistance;
        float xRot = (float)Math.toRadians(-user.m_146909_());
        float yRot = (float)Math.toRadians(-user.m_146908_());
        Vec3 eyeVec = new Vec3(0.0, 0.0, 1.0).m_82496_(xRot).m_82524_(yRot).m_82541_().m_82490_(distance);
        Vec3 centrePos = user.m_146892_().m_82546_(eyeVec);
        List entityList = user.m_9236_().m_45976_(LivingEntity.class, user.m_20191_().m_82400_(distance));
        com.google.common.base.Supplier realDamage = Suppliers.memoize(() -> {
            AttributeInstance instance = user.m_21051_(Attributes.f_22281_);
            if (instance == null) {
                return Float.valueOf(damage);
            }
            double oldBase = instance.m_22115_();
            AttributeModifier modifier = AM_FACTORY.apply(damage);
            try {
                instance.m_22100_(0.0);
                instance.m_22118_(modifier);
                Float f = Float.valueOf((float)instance.m_22135_());
                return f;
            }
            finally {
                instance.m_22100_(oldBase);
                instance.m_22130_(modifier);
            }
        });
        for (LivingEntity living : entityList) {
            double degree;
            Vec3 targetVec = living.m_146892_().m_82546_(centrePos);
            double targetLength = targetVec.m_82553_();
            if (targetLength < distance || !((degree = Math.toDegrees(Math.acos(targetVec.m_82526_(eyeVec) / (targetLength * distance)))) < (double)(rangeAngle / 2.0f)) || !user.m_142582_((Entity)living)) continue;
            ModernKineticGunItem.doPerLivingHurt(user, living, knockback, ((Float)realDamage.get()).floatValue(), effects);
        }
        if (user instanceof Player) {
            Player player = (Player)user;
            player.m_36399_(0.1f);
        }
        if (DebugCommand.DEBUG) {
            GunMeleeDebug.showRange(user, (int)Math.round(distance), centrePos, eyeVec, rangeAngle);
        }
    }

    private static void doPerLivingHurt(LivingEntity user, LivingEntity target, float knockback, float damage, List<EffectData> effects) {
        if (target.equals((Object)user)) {
            return;
        }
        target.m_147240_((double)knockback, (double)((float)Math.sin(Math.toRadians(user.m_146908_()))), (double)((float)(-Math.cos(Math.toRadians(user.m_146908_())))));
        if (user instanceof Player) {
            Player player = (Player)user;
            target.m_6469_(user.m_269291_().m_269075_(player), damage);
        } else {
            target.m_6469_(user.m_269291_().m_269333_(user), damage);
        }
        user.m_19970_(user, (Entity)target);
        if (!target.m_6084_()) {
            return;
        }
        for (EffectData effectData : effects) {
            MobEffect mobEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectData.getEffectId());
            if (mobEffect == null) continue;
            int time = Math.max(0, effectData.getTime() * 20);
            int amplifier = Math.max(0, effectData.getAmplifier());
            MobEffectInstance effectInstance = new MobEffectInstance(mobEffect, time, amplifier, false, effectData.isHideParticles());
            target.m_7292_(effectInstance);
        }
        Level level = user.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int n = (int)((double)damage * 0.5);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123798_, target.m_20185_(), target.m_20227_(0.5), target.m_20189_(), n, 0.1, 0.0, 0.1, 0.2);
        }
    }

    @Nullable
    private MeleeData getMeleeData(ResourceLocation attachmentId) {
        if (DefaultAssets.isEmptyAttachmentId(attachmentId)) {
            return null;
        }
        return TimelessAPI.getCommonAttachmentIndex(attachmentId).map(index -> index.getData().getMeleeData()).orElse(null);
    }

    private LuaFunction checkFunction(LuaValue luaValue) {
        if (luaValue.isfunction()) {
            return (LuaFunction)luaValue;
        }
        if (luaValue.isnil()) {
            return null;
        }
        throw new LuaError("bad argument: function or nil expected, got " + luaValue.typename());
    }

    @Override
    public void fireSelect(ShooterDataHolder dataHolder, ItemStack gunItem) {
        ResourceLocation gunId = this.getGunId(gunItem);
        TimelessAPI.getCommonGunIndex(gunId).map(gunIndex -> {
            FireMode fireMode = this.getFireMode(gunItem);
            List<FireMode> fireModeSet = gunIndex.getGunData().getFireModeSet();
            int nextIndex = (fireModeSet.indexOf((Object)fireMode) + 1) % fireModeSet.size();
            FireMode nextFireMode = fireModeSet.get(nextIndex);
            this.setFireMode(gunItem, nextFireMode);
            return nextFireMode;
        });
    }

    @Override
    public int getLevel(int exp) {
        return 0;
    }

    @Override
    public int getExp(int level) {
        return 0;
    }

    @Override
    public int getMaxLevel() {
        return 0;
    }
}

