/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource;

import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.tacz.guns.GunMod;
import com.tacz.guns.api.resource.ResourceManager;
import com.tacz.guns.config.PreLoadConfig;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.PackMeta;
import com.tacz.guns.util.GetJarResources;
import cpw.mods.jarhandling.SecureJar;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.zip.ZipFile;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.resource.DelegatingPackResources;
import net.minecraftforge.resource.PathPackResources;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum GunPackLoader implements RepositorySource
{
    INSTANCE;

    private static final Marker MARKER;
    public PackType packType;
    private boolean firstLoad = true;

    public void m_7686_(Consumer<Pack> pOnLoad) {
        Pack extensionsPack = this.discoverExtensions();
        if (extensionsPack != null) {
            pOnLoad.accept(extensionsPack);
        }
    }

    public Pack discoverExtensions() {
        Path resourcePacksPath = FMLPaths.GAMEDIR.get().resolve("tacz");
        File folder = resourcePacksPath.toFile();
        if (!folder.isDirectory()) {
            try {
                Files.createDirectories(folder.toPath(), new FileAttribute[0]);
            }
            catch (Exception e) {
                GunMod.LOGGER.warn(MARKER, "Failed to init tacz resource directory...", (Throwable)e);
                return null;
            }
        }
        PreLoadConfig.load(resourcePacksPath);
        if (this.firstLoad) {
            if (!((Boolean)PreLoadConfig.override.get()).booleanValue()) {
                for (ResourceManager.ExtraEntry entry : ResourceManager.EXTRA_ENTRIES) {
                    GetJarResources.copyModDirectory(entry.modMainClass(), entry.srcPath(), resourcePacksPath, entry.extraDirName());
                }
            }
            this.firstLoad = false;
        }
        List<GunPack> gunPacks = GunPackLoader.scanExtensions(resourcePacksPath);
        ArrayList<1> extensionPacks = new ArrayList<1>();
        for (final GunPack gunPack : gunPacks) {
            PathPackResources packResources = new PathPackResources(gunPack.name, false, gunPack.path){
                private final SecureJar secureJar;
                {
                    super(packId, isBuiltin, source);
                    this.secureJar = SecureJar.from((Path[])new Path[]{gunPack.path});
                }

                @NotNull
                protected Path resolve(String ... paths) {
                    if (paths.length < 1) {
                        throw new IllegalArgumentException("Missing path");
                    }
                    return this.secureJar.getPath(String.join((CharSequence)"/", paths), new String[0]);
                }

                public IoSupplier<InputStream> m_214146_(PackType type, ResourceLocation location) {
                    return super.m_214146_(type, location);
                }

                public void m_8031_(PackType type, String namespace, String path, PackResources.ResourceOutput resourceOutput) {
                    super.m_8031_(type, namespace, path, resourceOutput);
                }
            };
            extensionPacks.add(packResources);
        }
        return Pack.m_245429_((String)"tacz_resources", (Component)Component.m_237113_((String)"TACZ Resources"), (boolean)true, id -> new DelegatingPackResources(id, false, new PackMetadataSection((Component)Component.m_237115_((String)"tacz.resources.modresources"), SharedConstants.m_183709_().m_264084_(this.packType)), extensionPacks){

            public IoSupplier<InputStream> m_8017_(String ... paths) {
                Path logoPath;
                if (paths.length == 1 && paths[0].equals("pack.png") && (logoPath = GunPackLoader.getModIcon("tacz")) != null) {
                    return IoSupplier.m_246697_((Path)logoPath);
                }
                return null;
            }
        }, (PackType)this.packType, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10528_);
    }

    @Nullable
    public static Path getModIcon(String modId) {
        Path logoPath;
        IModInfo mod;
        IModFile file;
        Optional m = ModList.get().getModContainerById(modId);
        if (m.isPresent() && (file = (mod = ((ModContainer)m.get()).getModInfo()).getOwningFile().getFile()) != null && Files.exists(logoPath = file.findResource(new String[]{"icon.png"}), new LinkOption[0])) {
            return logoPath;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static GunPack fromDirPath(Path path) throws IOException {
        Path packInfoFilePath = path.resolve("gunpack.meta.json");
        try (InputStream stream = Files.newInputStream(packInfoFilePath, new OpenOption[0]);){
            PackMeta info = (PackMeta)CommonAssetsManager.GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), PackMeta.class);
            if (info == null) {
                GunMod.LOGGER.warn(MARKER, "Failed to read info json: {}", (Object)packInfoFilePath);
                GunPack gunPack = null;
                return gunPack;
            }
            if (info.getDependencies() != null && !GunPackLoader.modVersionAllMatch(info)) {
                GunMod.LOGGER.warn(MARKER, "Mod version mismatch: {}", (Object)packInfoFilePath);
                GunPack gunPack = null;
                return gunPack;
            }
            GunPack gunPack = new GunPack(path, info.getName());
            return gunPack;
        }
        catch (JsonIOException | JsonSyntaxException | IOException | InvalidVersionSpecificationException exception) {
            GunMod.LOGGER.warn(MARKER, "Failed to read info json: {}", (Object)packInfoFilePath);
            GunMod.LOGGER.warn(exception.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static GunPack fromZipPath(Path path) {
        try {
            block23: {
                block22: {
                    block21: {
                        zipFile = new ZipFile(path.toFile());
                        extDescriptorEntry = zipFile.getEntry("gunpack.meta.json");
                        if (extDescriptorEntry == null) {
                            GunMod.LOGGER.error(GunPackLoader.MARKER, "Failed to load extension from ZIP {}. Error: {}", (Object)path, (Object)"No gunpack.meta.json found");
                            var3_5 = null;
                        }
                        ** GOTO lbl14
                        {
                            catch (Throwable var2_4) {
                                throw var2_4;
                            }
                            zipFile.close();
                            return var3_5;
lbl14:
                            // 1 sources

                            stream = zipFile.getInputStream(extDescriptorEntry);
                            try {
                                info = (PackMeta)CommonAssetsManager.GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), PackMeta.class);
                                if (info == null) {
                                    GunMod.LOGGER.warn(GunPackLoader.MARKER, "Failed to read info json: {}", (Object)path);
                                    var5_11 = null;
                                    if (stream == null) break block21;
                                }
                                ** GOTO lbl-1000
                            }
                            catch (Throwable var4_10) {}
                            ** try [egrp 8[TRYBLOCK] [24 : 200->245)] { 
lbl25:
                            // 1 sources

                            try {
                                if (stream == null) throw var4_10;
                                try {
                                    stream.close();
                                    throw var4_10;
                                }
                                catch (Throwable var5_14) {
                                    var4_10.addSuppressed(var5_14);
                                }
                                throw var4_10;
                            }
                            catch (JsonIOException | JsonSyntaxException | IOException | InvalidVersionSpecificationException e) {
                                GunMod.LOGGER.error(GunPackLoader.MARKER, "Failed to load extension from ZIP {}. Error: {}", (Object)path, (Object)e);
                                return null;
                            }
lbl36:
                            // 1 sources

                            finally {
                                zipFile.close();
                            }
                        }
                        stream.close();
                    }
                    zipFile.close();
                    return var5_11;
lbl-1000:
                    // 1 sources

                    {
                        if (info.getDependencies() == null || GunPackLoader.modVersionAllMatch(info)) ** GOTO lbl-1000
                        GunMod.LOGGER.warn(GunPackLoader.MARKER, "Mod version mismatch: {}", (Object)path);
                        var5_12 = null;
                        if (stream == null) break block22;
                    }
                    stream.close();
                }
                zipFile.close();
                return var5_12;
lbl-1000:
                // 1 sources

                {
                    var5_13 = new GunPack(path, info.getName());
                    if (stream == null) break block23;
                }
                stream.close();
            }
            zipFile.close();
            return var5_13;
        }
        catch (IOException e) {
            GunMod.LOGGER.error(GunPackLoader.MARKER, "Failed to load extension from ZIP {}. Error: {}", (Object)path, (Object)e);
            return null;
        }
    }

    private static List<GunPack> scanExtensions(Path extensionsPath) {
        ArrayList<GunPack> gunPacks = new ArrayList<GunPack>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(extensionsPath);){
            for (Path entry : stream) {
                GunPack gunPack = null;
                if (Files.isDirectory(entry, new LinkOption[0])) {
                    gunPack = GunPackLoader.fromDirPath(entry);
                } else if (entry.toString().endsWith(".zip")) {
                    gunPack = GunPackLoader.fromZipPath(entry);
                }
                if (gunPack == null) continue;
                gunPacks.add(gunPack);
            }
        }
        catch (IOException e) {
            GunMod.LOGGER.error(MARKER, "Failed to scan extensions from {}. Error: {}", (Object)extensionsPath, (Object)e);
        }
        return gunPacks;
    }

    private static boolean modVersionAllMatch(PackMeta info) throws InvalidVersionSpecificationException {
        HashMap<String, String> dependencies = info.getDependencies();
        for (String modId : dependencies.keySet()) {
            if (GunPackLoader.modVersionMatch(modId, dependencies.get(modId))) continue;
            return false;
        }
        return true;
    }

    private static boolean modVersionMatch(String modId, String version) throws InvalidVersionSpecificationException {
        VersionRange versionRange = VersionRange.createFromVersionSpec((String)version);
        return ModList.get().getModContainerById(modId).map(mod -> {
            ArtifactVersion modVersion = mod.getModInfo().getVersion();
            return versionRange.containsVersion(modVersion);
        }).orElse(false);
    }

    static {
        MARKER = MarkerManager.getMarker((String)"GunPackFinder");
    }

    public record GunPack(Path path, String name) {
    }
}

